package com.xforceplus.ultraman.app.policymanagement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-11-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class JdSalesOrderDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 京东ID
   */
  private Long jdId;

  /**
   * 店铺编号
   */
  private String storeId;

  /**
   * 订单编号
   */
  private String orderNo;

  /**
   * 商品id
   */
  private String goodsId;

  /**
   * 商品名称
   */
  private String goodsName;

  /**
   * 订购数量
   */
  private String goodsNum;

  /**
   * 支付方式
   */
  private String payType;

  /**
   * 京东价
   */
  private BigDecimal jdPrice;

  /**
   * 订单金额
   */
  private BigDecimal orderAmount;

  /**
   * 结算金额
   */
  private BigDecimal settleAmount;

  /**
   * 余额支付
   */
  private BigDecimal balancePay;

  /**
   * 应付金额
   */
  private BigDecimal payableAmount;

  /**
   * 订单状态
   */
  private String orderStatus;

  /**
   * 订单类型
   */
  private String orderType;

  /**
   * 订单标签
   */
  private String orderTag;

  /**
   * 商家备注
   */
  private String merchantRemark;

  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtCreate;

  /**
   * 更新时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtModified;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 下单帐号
   */
  private String orderAccount;

  /**
   * 客户姓名
   */
  private String customerName;

  /**
   * 客户地址
   */
  private String customerAddress;

  /**
   * 联系电话
   */
  private String contactPhone;

  /**
   * 虚拟号过期时间
   */
  private String virtualExpireTime;

  /**
   * 订单备注
   */
  private String orderRemark;

  /**
   * 发票类型
   */
  private String invoiceType;

  /**
   * 发票抬头
   */
  private String invoiceTitle;

  /**
   * 发票内容
   */
  private String invoiceContent;

  /**
   * 纳税人识别号
   */
  private String invoiceTaxNo;

  /**
   * 名称（个人）
   */
  private String name;

  /**
   * 单位地址
   */
  private String companyAddress;

  /**
   * 单位电话
   */
  private String companyPhone;

  /**
   * 开户银行
   */
  private String bankName;

  /**
   * 银行账号
   */
  private String bankAccount;

  /**
   * 商家备注等级
   */
  private String merchantRemarkLevel;

  /**
   * 运费金额
   */
  private BigDecimal freight;

  /**
   * 付款确认时间
   */
  private String payConfirmTime;

  /**
   * 货号
   */
  private String goodId;

  /**
   * 订单来源
   */
  private String orderSource;

  /**
   * 订单渠道
   */
  private String oderChannel;

  /**
   * 送装服务
   */
  private String deliveryService;

  /**
   * 服务费
   */
  private BigDecimal serviceFee;

  /**
   * 仓库id
   */
  private String warehouseId;

  /**
   * 仓库名称
   */
  private String warehouseName;

  /**
   * 商家SKUID
   */
  private String merchantSkuId;

  /**
   * 邮箱地址
   */
  private String email;

  /**
   * 邮政编码
   */
  private String postalCode;

  /**
   * 是否为品牌商订单
   */
  private Boolean brandOrderFlag;

  /**
   * 是否为toplife订单
   */
  private Boolean topLifeFlag;

  /**
   * 业务类型
   */
  private String businessType;

  /**
   * 履约门店ID
   */
  private String keepStoreId;

  /**
   * 下单门店Id
   */
  private String orderStoreId;

  /**
   * 门店名称
   */
  private String storeName;

  /**
   * 门店联系人
   */
  private String storeContactName;

  /**
   * 门店联系电话
   */
  private String storeContactPhone;

  /**
   * 门店地址
   */
  private String storeAddress;

  /**
   * 导购员账号
   */
  private String shoppingGuideAccount;

  /**
   * 延迟报备类型
   */
  private String lazyReportType;

  /**
   * 订单出库时间
   */
  private String oderOutTime;

  /**
   * 客户类型
   */
  private String customerType;

  /**
   * KA订单发货需提供单据
   */
  private String kaOrderDelivery;

  /**
   * KA订单客户收货要求
   */
  private String kaOrderReceive;

  /**
   * 正品鉴定校验结果
   */
  private String realIdtfResult;

  /**
   * 正品鉴定补充说明
   */
  private String realIdtfSupplement;

  /**
   * 正品鉴定不合格原因
   */
  private String realIdtfRejectReason;

  /**
   * 正品鉴定图片链接
   */
  private String realIdtfPictureUrl;

  /**
   * 企配订单
   */
  private String orderQpFlag;

  /**
   * 需上传SN码
   */
  private String snUploadFlag;

  /**
   * SN码
   */
  private String snCode;

  /**
   * SN码有效状态
   */
  private String snValid;

  /**
   * SN码激活状态
   */
  private String snActive;

  /**
   * SN码补贴状态
   */
  private String snSubsidy;

  /**
   * 百补满赠
   */
  private String bbmzFlag;

  /**
   * 买一试三
   */
  private String myssFlag;

  /**
   * 承诺发货时间
   */
  private String promiseDeliveryTime;

  /**
   * 款项名称
   */
  private String amountItemName;

  /**
   * 项目ID
   */
  private String projectId;

  /**
   * 市
   */
  private String city;

  /**
   * 订单完成时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime orderFinishTime;

  /**
   * 获取账单日期
   */
  private String acqBillDate;

  /**
   * 下单时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime orderTime;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("jd_id", jdId);
      map.put("store_id", storeId);
      map.put("order_no", orderNo);
      map.put("goods_id", goodsId);
      map.put("goods_name", goodsName);
      map.put("goods_num", goodsNum);
      map.put("pay_type", payType);
      map.put("jd_price", jdPrice);
      map.put("order_amount", orderAmount);
      map.put("settle_amount", settleAmount);
      map.put("balance_pay", balancePay);
      map.put("payable_amount", payableAmount);
      map.put("order_status", orderStatus);
      map.put("order_type", orderType);
      map.put("order_tag", orderTag);
      map.put("merchant_remark", merchantRemark);
      map.put("gmt_create", BocpGenUtils.toTimestamp(gmtCreate));
      map.put("gmt_modified", BocpGenUtils.toTimestamp(gmtModified));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("order_account", orderAccount);
      map.put("customer_name", customerName);
      map.put("customer_address", customerAddress);
      map.put("contact_phone", contactPhone);
      map.put("virtual_expire_time", virtualExpireTime);
      map.put("order_remark", orderRemark);
      map.put("invoice_type", invoiceType);
      map.put("invoice_title", invoiceTitle);
      map.put("invoice_content", invoiceContent);
      map.put("invoice_tax_no", invoiceTaxNo);
      map.put("name", name);
      map.put("company_address", companyAddress);
      map.put("company_phone", companyPhone);
      map.put("bank_name", bankName);
      map.put("bank_account", bankAccount);
      map.put("merchant_remark_level", merchantRemarkLevel);
      map.put("freight", freight);
      map.put("pay_confirm_time", payConfirmTime);
      map.put("good_id", goodId);
      map.put("order_source", orderSource);
      map.put("oder_channel", oderChannel);
      map.put("delivery_service", deliveryService);
      map.put("service_fee", serviceFee);
      map.put("warehouse_id", warehouseId);
      map.put("warehouse_name", warehouseName);
      map.put("merchant_sku_id", merchantSkuId);
      map.put("email", email);
      map.put("postal_code", postalCode);
      map.put("brand_order_flag", brandOrderFlag);
      map.put("top_life_flag", topLifeFlag);
      map.put("business_type", businessType);
      map.put("keep_store_id", keepStoreId);
      map.put("order_store_id", orderStoreId);
      map.put("store_name", storeName);
      map.put("store_contact_name", storeContactName);
      map.put("store_contact_phone", storeContactPhone);
      map.put("store_address", storeAddress);
      map.put("shopping_guide_account", shoppingGuideAccount);
      map.put("lazy_report_type", lazyReportType);
      map.put("oder_out_time", oderOutTime);
      map.put("customer_type", customerType);
      map.put("ka_order_delivery", kaOrderDelivery);
      map.put("ka_order_receive", kaOrderReceive);
      map.put("real_idtf_result", realIdtfResult);
      map.put("real_idtf_supplement", realIdtfSupplement);
      map.put("real_idtf_reject_reason", realIdtfRejectReason);
      map.put("real_idtf_picture_url", realIdtfPictureUrl);
      map.put("order_qp_flag", orderQpFlag);
      map.put("sn_upload_flag", snUploadFlag);
      map.put("sn_code", snCode);
      map.put("sn_valid", snValid);
      map.put("sn_active", snActive);
      map.put("sn_subsidy", snSubsidy);
      map.put("bbmz_flag", bbmzFlag);
      map.put("myss_flag", myssFlag);
      map.put("promise_delivery_time", promiseDeliveryTime);
      map.put("amount_item_name", amountItemName);
      map.put("project_id", projectId);
      map.put("city", city);
      map.put("order_finish_time", BocpGenUtils.toTimestamp(orderFinishTime));
      map.put("acq_bill_date", acqBillDate);
      map.put("order_time", BocpGenUtils.toTimestamp(orderTime));
      map.put("org_tree", orgTree);

      return map;
  }

  public static JdSalesOrderDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    JdSalesOrderDetail entity = new JdSalesOrderDetail();
    if(map.containsKey("jd_id")) {
      Object obj = map.get("jd_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setJdId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJdId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setJdId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_id")) {
      Object obj = map.get("goods_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_name")) {
      Object obj = map.get("goods_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_num")) {
      Object obj = map.get("goods_num");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_type")) {
      Object obj = map.get("pay_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jd_price")) {
      Object obj = map.get("jd_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setJdPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setJdPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setJdPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJdPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setJdPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("order_amount")) {
      Object obj = map.get("order_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("settle_amount")) {
      Object obj = map.get("settle_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSettleAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSettleAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSettleAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSettleAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSettleAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("balance_pay")) {
      Object obj = map.get("balance_pay");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBalancePay((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBalancePay(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBalancePay(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBalancePay(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBalancePay(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("payable_amount")) {
      Object obj = map.get("payable_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayableAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayableAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayableAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayableAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayableAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("order_status")) {
      Object obj = map.get("order_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_type")) {
      Object obj = map.get("order_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_tag")) {
      Object obj = map.get("order_tag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("merchant_remark")) {
      Object obj = map.get("merchant_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMerchantRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_account")) {
      Object obj = map.get("order_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_name")) {
      Object obj = map.get("customer_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_address")) {
      Object obj = map.get("customer_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contact_phone")) {
      Object obj = map.get("contact_phone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContactPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("virtual_expire_time")) {
      Object obj = map.get("virtual_expire_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVirtualExpireTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_remark")) {
      Object obj = map.get("order_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_title")) {
      Object obj = map.get("invoice_title");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_content")) {
      Object obj = map.get("invoice_content");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceContent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_tax_no")) {
      Object obj = map.get("invoice_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("name")) {
      Object obj = map.get("name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_address")) {
      Object obj = map.get("company_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_phone")) {
      Object obj = map.get("company_phone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bank_name")) {
      Object obj = map.get("bank_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bank_account")) {
      Object obj = map.get("bank_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("merchant_remark_level")) {
      Object obj = map.get("merchant_remark_level");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMerchantRemarkLevel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freight")) {
      Object obj = map.get("freight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFreight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFreight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFreight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFreight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFreight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("pay_confirm_time")) {
      Object obj = map.get("pay_confirm_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayConfirmTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("good_id")) {
      Object obj = map.get("good_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_source")) {
      Object obj = map.get("order_source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oder_channel")) {
      Object obj = map.get("oder_channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOderChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delivery_service")) {
      Object obj = map.get("delivery_service");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryService((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("service_fee")) {
      Object obj = map.get("service_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setServiceFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setServiceFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setServiceFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setServiceFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setServiceFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("warehouse_id")) {
      Object obj = map.get("warehouse_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWarehouseId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warehouse_name")) {
      Object obj = map.get("warehouse_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWarehouseName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("merchant_sku_id")) {
      Object obj = map.get("merchant_sku_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMerchantSkuId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("email")) {
      Object obj = map.get("email");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postal_code")) {
      Object obj = map.get("postal_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPostalCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brand_order_flag")) {
      Object obj = map.get("brand_order_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setBrandOrderFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBrandOrderFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("top_life_flag")) {
      Object obj = map.get("top_life_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setTopLifeFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTopLifeFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("keep_store_id")) {
      Object obj = map.get("keep_store_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKeepStoreId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_store_id")) {
      Object obj = map.get("order_store_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderStoreId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_name")) {
      Object obj = map.get("store_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_contact_name")) {
      Object obj = map.get("store_contact_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreContactName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_contact_phone")) {
      Object obj = map.get("store_contact_phone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreContactPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_address")) {
      Object obj = map.get("store_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shopping_guide_account")) {
      Object obj = map.get("shopping_guide_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShoppingGuideAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lazy_report_type")) {
      Object obj = map.get("lazy_report_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLazyReportType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oder_out_time")) {
      Object obj = map.get("oder_out_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOderOutTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_type")) {
      Object obj = map.get("customer_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ka_order_delivery")) {
      Object obj = map.get("ka_order_delivery");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKaOrderDelivery((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ka_order_receive")) {
      Object obj = map.get("ka_order_receive");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKaOrderReceive((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("real_idtf_result")) {
      Object obj = map.get("real_idtf_result");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRealIdtfResult((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("real_idtf_supplement")) {
      Object obj = map.get("real_idtf_supplement");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRealIdtfSupplement((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("real_idtf_reject_reason")) {
      Object obj = map.get("real_idtf_reject_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRealIdtfRejectReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("real_idtf_picture_url")) {
      Object obj = map.get("real_idtf_picture_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRealIdtfPictureUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_qp_flag")) {
      Object obj = map.get("order_qp_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderQpFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sn_upload_flag")) {
      Object obj = map.get("sn_upload_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSnUploadFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sn_code")) {
      Object obj = map.get("sn_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSnCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sn_valid")) {
      Object obj = map.get("sn_valid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSnValid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sn_active")) {
      Object obj = map.get("sn_active");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSnActive((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sn_subsidy")) {
      Object obj = map.get("sn_subsidy");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSnSubsidy((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bbmz_flag")) {
      Object obj = map.get("bbmz_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBbmzFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("myss_flag")) {
      Object obj = map.get("myss_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMyssFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("promise_delivery_time")) {
      Object obj = map.get("promise_delivery_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPromiseDeliveryTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_item_name")) {
      Object obj = map.get("amount_item_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAmountItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("project_id")) {
      Object obj = map.get("project_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("city")) {
      Object obj = map.get("city");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_finish_time")) {
      Object obj = map.get("order_finish_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderFinishTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setOrderFinishTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderFinishTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOrderFinishTime(null);
      }
    }
    if(map.containsKey("acq_bill_date")) {
      Object obj = map.get("acq_bill_date");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAcqBillDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_time")) {
      Object obj = map.get("order_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setOrderTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOrderTime(null);
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("jd_id")) {
      Object obj = map.get("jd_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setJdId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setJdId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setJdId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_id")) {
      Object obj = map.get("goods_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_name")) {
      Object obj = map.get("goods_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_num")) {
      Object obj = map.get("goods_num");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsNum((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_type")) {
      Object obj = map.get("pay_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jd_price")) {
      Object obj = map.get("jd_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setJdPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setJdPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setJdPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setJdPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setJdPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("order_amount")) {
      Object obj = map.get("order_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOrderAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOrderAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOrderAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("settle_amount")) {
      Object obj = map.get("settle_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSettleAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSettleAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSettleAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSettleAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSettleAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("balance_pay")) {
      Object obj = map.get("balance_pay");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBalancePay((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBalancePay(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBalancePay(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBalancePay(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBalancePay(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("payable_amount")) {
      Object obj = map.get("payable_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPayableAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPayableAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPayableAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayableAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayableAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("order_status")) {
      Object obj = map.get("order_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_type")) {
      Object obj = map.get("order_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_tag")) {
      Object obj = map.get("order_tag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderTag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("merchant_remark")) {
      Object obj = map.get("merchant_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMerchantRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_account")) {
      Object obj = map.get("order_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customer_name")) {
      Object obj = map.get("customer_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customer_address")) {
      Object obj = map.get("customer_address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("contact_phone")) {
      Object obj = map.get("contact_phone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContactPhone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("virtual_expire_time")) {
      Object obj = map.get("virtual_expire_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVirtualExpireTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_remark")) {
      Object obj = map.get("order_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_title")) {
      Object obj = map.get("invoice_title");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceTitle((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_content")) {
      Object obj = map.get("invoice_content");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceContent((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_tax_no")) {
      Object obj = map.get("invoice_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("name")) {
      Object obj = map.get("name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_address")) {
      Object obj = map.get("company_address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_phone")) {
      Object obj = map.get("company_phone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyPhone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bank_name")) {
      Object obj = map.get("bank_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bank_account")) {
      Object obj = map.get("bank_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("merchant_remark_level")) {
      Object obj = map.get("merchant_remark_level");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMerchantRemarkLevel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("freight")) {
      Object obj = map.get("freight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setFreight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setFreight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setFreight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setFreight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setFreight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("pay_confirm_time")) {
      Object obj = map.get("pay_confirm_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayConfirmTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("good_id")) {
      Object obj = map.get("good_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_source")) {
      Object obj = map.get("order_source");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("oder_channel")) {
      Object obj = map.get("oder_channel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOderChannel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delivery_service")) {
      Object obj = map.get("delivery_service");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliveryService((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("service_fee")) {
      Object obj = map.get("service_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setServiceFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setServiceFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setServiceFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setServiceFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setServiceFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("warehouse_id")) {
      Object obj = map.get("warehouse_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWarehouseId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warehouse_name")) {
      Object obj = map.get("warehouse_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWarehouseName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("merchant_sku_id")) {
      Object obj = map.get("merchant_sku_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMerchantSkuId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("email")) {
      Object obj = map.get("email");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("postal_code")) {
      Object obj = map.get("postal_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPostalCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("brand_order_flag")) {
      Object obj = map.get("brand_order_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setBrandOrderFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBrandOrderFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("top_life_flag")) {
      Object obj = map.get("top_life_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setTopLifeFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTopLifeFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("keep_store_id")) {
      Object obj = map.get("keep_store_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setKeepStoreId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_store_id")) {
      Object obj = map.get("order_store_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderStoreId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("store_name")) {
      Object obj = map.get("store_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("store_contact_name")) {
      Object obj = map.get("store_contact_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreContactName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("store_contact_phone")) {
      Object obj = map.get("store_contact_phone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreContactPhone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("store_address")) {
      Object obj = map.get("store_address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shopping_guide_account")) {
      Object obj = map.get("shopping_guide_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShoppingGuideAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lazy_report_type")) {
      Object obj = map.get("lazy_report_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLazyReportType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("oder_out_time")) {
      Object obj = map.get("oder_out_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOderOutTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customer_type")) {
      Object obj = map.get("customer_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ka_order_delivery")) {
      Object obj = map.get("ka_order_delivery");
      if(obj != null) {
        if(obj instanceof String) {
          this.setKaOrderDelivery((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ka_order_receive")) {
      Object obj = map.get("ka_order_receive");
      if(obj != null) {
        if(obj instanceof String) {
          this.setKaOrderReceive((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("real_idtf_result")) {
      Object obj = map.get("real_idtf_result");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRealIdtfResult((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("real_idtf_supplement")) {
      Object obj = map.get("real_idtf_supplement");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRealIdtfSupplement((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("real_idtf_reject_reason")) {
      Object obj = map.get("real_idtf_reject_reason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRealIdtfRejectReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("real_idtf_picture_url")) {
      Object obj = map.get("real_idtf_picture_url");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRealIdtfPictureUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_qp_flag")) {
      Object obj = map.get("order_qp_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderQpFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sn_upload_flag")) {
      Object obj = map.get("sn_upload_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSnUploadFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sn_code")) {
      Object obj = map.get("sn_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSnCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sn_valid")) {
      Object obj = map.get("sn_valid");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSnValid((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sn_active")) {
      Object obj = map.get("sn_active");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSnActive((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sn_subsidy")) {
      Object obj = map.get("sn_subsidy");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSnSubsidy((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bbmz_flag")) {
      Object obj = map.get("bbmz_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBbmzFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("myss_flag")) {
      Object obj = map.get("myss_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMyssFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("promise_delivery_time")) {
      Object obj = map.get("promise_delivery_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPromiseDeliveryTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount_item_name")) {
      Object obj = map.get("amount_item_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAmountItemName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("project_id")) {
      Object obj = map.get("project_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProjectId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("city")) {
      Object obj = map.get("city");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_finish_time")) {
      Object obj = map.get("order_finish_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderFinishTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setOrderFinishTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderFinishTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setOrderFinishTime(null);
      }
    }
    if(map.containsKey("acq_bill_date")) {
      Object obj = map.get("acq_bill_date");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAcqBillDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_time")) {
      Object obj = map.get("order_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setOrderTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setOrderTime(null);
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
