package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * check_result
 * </p>
 *
 * @author ultraman
 * @since 2024-11-26
 */
public enum CheckResult {

    _0("0", "允差外不通过"),
    _1("1", "允差内通过"),
    _9("9", "对账异常");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CheckResult(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CheckResult fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "9":
                return _9;
            default:
                return null;
        }
    }
}
