package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * income_type
 * </p>
 *
 * @author ultraman
 * @since 2024-11-26
 */
public enum IncomeType {

    R("R", "收入"),
    E("E", "费用"),
    O("O", "其他"),
    A("A", "售后"),
    CL("CL", "合同负债"),
    RO("RO", "仅退款");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    IncomeType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IncomeType fromCode(String code){
        switch(code) {
            case "R":
                return R;
            case "E":
                return E;
            case "O":
                return O;
            case "A":
                return A;
            case "CL":
                return CL;
            case "RO":
                return RO;
            default:
                return null;
        }
    }
}
