package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ksrefundstatus
 * </p>
 *
 * @author ultraman
 * @since 2024-11-26
 */
public enum Ksrefundstatus {

    _10("10", "买家已经申请退款，等待卖家同意"),
    _12("12", "卖家已拒绝，等待买家处理"),
    _20("20", "协商纠纷，等待平台处理"),
    _30("30", "卖家已经同意退款，等待买家退货"),
    _40("40", "买家已经退货，等待卖家确认收货"),
    _45("45", "卖家已经发货，等待买家确认收货"),
    _50("50", "卖家已经同意退款，等待系统执行退款"),
    _60("60", "退款成功"),
    _70("70", "退款关闭");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Ksrefundstatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Ksrefundstatus fromCode(String code){
        switch(code) {
            case "10":
                return _10;
            case "12":
                return _12;
            case "20":
                return _20;
            case "30":
                return _30;
            case "40":
                return _40;
            case "45":
                return _45;
            case "50":
                return _50;
            case "60":
                return _60;
            case "70":
                return _70;
            default:
                return null;
        }
    }
}
