package com.xforceplus.ultraman.app.policymanagement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-11-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class JdAfterSale implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 京东售后id
   */
  private String jdId;

  /**
   * 账单获取日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime acqBillDate;

  /**
   * 店铺编号
   */
  private String shopId;

  /**
   * 租户编号
   */
  private String jdTenantCode;

  /**
   * 服务单号
   */
  private String ticketNo;

  /**
   * 客户期望
   */
  private String customerExpectation;

  /**
   * 服务单状态
   */
  private String ticketStatus;

  /**
   * 一级申请原因
   */
  private String primaryApplicationReason;

  /**
   * 二级申请原因
   */
  private String secondaryApplicationReason;

  /**
   * 客户问题描述
   */
  private String problemDesc;

  /**
   * 返回方式
   */
  private String returnWay;

  /**
   * 售后申请时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime applyTime;

  /**
   * 订单号
   */
  private String orderNo;

  /**
   * 订单类型
   */
  private String orderType;

  /**
   * 出库状态
   */
  private String outboundStatus;

  /**
   * 下单账号
   */
  private String orderingAccount;

  /**
   * 订单备注
   */
  private String remark;

  /**
   * 商品编号
   */
  private String productCode;

  /**
   * 商品名称
   */
  private String productName;

  /**
   * 商品金额
   */
  private BigDecimal productAmount;

  /**
   * 商品数量
   */
  private Long qty;

  /**
   * 审核结果
   */
  private String reviewResult;

  /**
   * 审核时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime reviewTime;

  /**
   * 审核意见
   */
  private String reviewOpinion;

  /**
   * 审核人姓名
   */
  private String reviewerName;

  /**
   * 取件时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime pickupTime;

  /**
   * 取件状态
   */
  private String pickupStatus;

  /**
   * 发货时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime shippingTime;

  /**
   * 运单号
   */
  private String shippingNumber;

  /**
   * 运费金额
   */
  private BigDecimal shippingFee;

  /**
   * 快递公司
   */
  private String courierCompany;

  /**
   * 商家收货时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime merchantReceiptTime;

  /**
   * 收货登记原因
   */
  private String receiptReason;

  /**
   * 收货人
   */
  private String receiver;

  /**
   * 处理结果
   */
  private String processingResult;

  /**
   * 处理人
   */
  private String processor;

  /**
   * 退款金额
   */
  private BigDecimal refundAmount;

  /**
   * 换新订单
   */
  private String replacementOrder;

  /**
   * 换新商品编号
   */
  private String replacementProductCode;

  /**
   * 自动审核类型
   */
  private String automaticReviewType;

  /**
   * 是否闪退订单
   */
  private String isFlashReturn;

  /**
   * 商家首次审核时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime firstReviewTime;

  /**
   * 商家首次处理时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime firstProcessingTime;

  /**
   * 暂完结时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime temporaryConclusionTime;

  /**
   * 售后整体时长(H)
   */
  private Long totalHours;

  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtCreate;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 单据流转处理状态
   */
  private String dealStatus;

  /**
   * 业务ID
   */
  private String businessId;

  /**
   * 对账状态
   */
  @TableField("checkStatus")
  private String checkStatus;

  /**
   * 数据MD5
   */
  @TableField("dataMD5")
  private String dataMD5;

  /**
   * 异常信息
   */
  private String errorMsg;

  /**
   * 申请时订单状态
   */
  private String applyingOrderStatus;

  /**
   * 对账金额
   */
  private BigDecimal checkAmount;

  /**
   * 店铺名称
   */
  private String shopName;

  /**
   * 事业部名称
   */
  private String bussinessUnitName;

  /**
   * 公司名称
   */
  private String companyName;

  /**
   * 公司税号
   */
  private String companyTaxNo;

  /**
   * 最新版本
   */
  private Boolean latest;

  /**
   * 账期
   */
  private String accountPeriod;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("jd_id", jdId);
      map.put("acq_bill_date", BocpGenUtils.toTimestamp(acqBillDate));
      map.put("shop_id", shopId);
      map.put("jd_tenant_code", jdTenantCode);
      map.put("ticket_no", ticketNo);
      map.put("customer_expectation", customerExpectation);
      map.put("ticket_status", ticketStatus);
      map.put("primary_application_reason", primaryApplicationReason);
      map.put("secondary_application_reason", secondaryApplicationReason);
      map.put("problem_desc", problemDesc);
      map.put("return_way", returnWay);
      map.put("apply_time", BocpGenUtils.toTimestamp(applyTime));
      map.put("order_no", orderNo);
      map.put("order_type", orderType);
      map.put("outbound_status", outboundStatus);
      map.put("ordering_account", orderingAccount);
      map.put("remark", remark);
      map.put("product_code", productCode);
      map.put("product_name", productName);
      map.put("product_amount", productAmount);
      map.put("qty", qty);
      map.put("review_result", reviewResult);
      map.put("review_time", BocpGenUtils.toTimestamp(reviewTime));
      map.put("review_opinion", reviewOpinion);
      map.put("reviewer_name", reviewerName);
      map.put("pickup_time", BocpGenUtils.toTimestamp(pickupTime));
      map.put("pickup_status", pickupStatus);
      map.put("shipping_time", BocpGenUtils.toTimestamp(shippingTime));
      map.put("shipping_number", shippingNumber);
      map.put("shipping_fee", shippingFee);
      map.put("courier_company", courierCompany);
      map.put("merchant_receipt_time", BocpGenUtils.toTimestamp(merchantReceiptTime));
      map.put("receipt_reason", receiptReason);
      map.put("receiver", receiver);
      map.put("processing_result", processingResult);
      map.put("processor", processor);
      map.put("refund_amount", refundAmount);
      map.put("replacement_order", replacementOrder);
      map.put("replacement_product_code", replacementProductCode);
      map.put("automatic_review_type", automaticReviewType);
      map.put("is_flash_return", isFlashReturn);
      map.put("first_review_time", BocpGenUtils.toTimestamp(firstReviewTime));
      map.put("first_processing_time", BocpGenUtils.toTimestamp(firstProcessingTime));
      map.put("temporary_conclusion_time", BocpGenUtils.toTimestamp(temporaryConclusionTime));
      map.put("total_hours", totalHours);
      map.put("gmt_create", BocpGenUtils.toTimestamp(gmtCreate));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("deal_status", dealStatus);
      map.put("business_id", businessId);
      map.put("checkStatus", checkStatus);
      map.put("dataMD5", dataMD5);
      map.put("error_msg", errorMsg);
      map.put("applying_order_status", applyingOrderStatus);
      map.put("check_amount", checkAmount);
      map.put("shop_name", shopName);
      map.put("bussiness_unit_name", bussinessUnitName);
      map.put("company_name", companyName);
      map.put("company_tax_no", companyTaxNo);
      map.put("latest", latest);
      map.put("account_period", accountPeriod);
      map.put("org_tree", orgTree);

      return map;
  }

  public static JdAfterSale fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    JdAfterSale entity = new JdAfterSale();
    if(map.containsKey("jd_id")) {
      Object obj = map.get("jd_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJdId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("acq_bill_date")) {
      Object obj = map.get("acq_bill_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAcqBillDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAcqBillDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAcqBillDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAcqBillDate(null);
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jd_tenant_code")) {
      Object obj = map.get("jd_tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJdTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_no")) {
      Object obj = map.get("ticket_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTicketNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_expectation")) {
      Object obj = map.get("customer_expectation");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerExpectation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_status")) {
      Object obj = map.get("ticket_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTicketStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("primary_application_reason")) {
      Object obj = map.get("primary_application_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPrimaryApplicationReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("secondary_application_reason")) {
      Object obj = map.get("secondary_application_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSecondaryApplicationReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("problem_desc")) {
      Object obj = map.get("problem_desc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProblemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("return_way")) {
      Object obj = map.get("return_way");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnWay((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apply_time")) {
      Object obj = map.get("apply_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setApplyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setApplyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApplyTime(null);
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_type")) {
      Object obj = map.get("order_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outbound_status")) {
      Object obj = map.get("outbound_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOutboundStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ordering_account")) {
      Object obj = map.get("ordering_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderingAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_code")) {
      Object obj = map.get("product_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_name")) {
      Object obj = map.get("product_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_amount")) {
      Object obj = map.get("product_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setProductAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setProductAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setProductAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setProductAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setProductAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("qty")) {
      Object obj = map.get("qty");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setQty((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQty(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQty(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("review_result")) {
      Object obj = map.get("review_result");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReviewResult((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("review_time")) {
      Object obj = map.get("review_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReviewTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setReviewTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReviewTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReviewTime(null);
      }
    }
    if(map.containsKey("review_opinion")) {
      Object obj = map.get("review_opinion");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReviewOpinion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reviewer_name")) {
      Object obj = map.get("reviewer_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReviewerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pickup_time")) {
      Object obj = map.get("pickup_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPickupTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPickupTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPickupTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPickupTime(null);
      }
    }
    if(map.containsKey("pickup_status")) {
      Object obj = map.get("pickup_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPickupStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipping_time")) {
      Object obj = map.get("shipping_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setShippingTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setShippingTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setShippingTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setShippingTime(null);
      }
    }
    if(map.containsKey("shipping_number")) {
      Object obj = map.get("shipping_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShippingNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipping_fee")) {
      Object obj = map.get("shipping_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setShippingFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setShippingFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setShippingFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setShippingFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setShippingFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("courier_company")) {
      Object obj = map.get("courier_company");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCourierCompany((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("merchant_receipt_time")) {
      Object obj = map.get("merchant_receipt_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMerchantReceiptTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setMerchantReceiptTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMerchantReceiptTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setMerchantReceiptTime(null);
      }
    }
    if(map.containsKey("receipt_reason")) {
      Object obj = map.get("receipt_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiptReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiver")) {
      Object obj = map.get("receiver");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiver((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("processing_result")) {
      Object obj = map.get("processing_result");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcessingResult((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("processor")) {
      Object obj = map.get("processor");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcessor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_amount")) {
      Object obj = map.get("refund_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRefundAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRefundAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRefundAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRefundAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRefundAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("replacement_order")) {
      Object obj = map.get("replacement_order");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReplacementOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("replacement_product_code")) {
      Object obj = map.get("replacement_product_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReplacementProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("automatic_review_type")) {
      Object obj = map.get("automatic_review_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAutomaticReviewType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_flash_return")) {
      Object obj = map.get("is_flash_return");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsFlashReturn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("first_review_time")) {
      Object obj = map.get("first_review_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFirstReviewTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setFirstReviewTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFirstReviewTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setFirstReviewTime(null);
      }
    }
    if(map.containsKey("first_processing_time")) {
      Object obj = map.get("first_processing_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFirstProcessingTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setFirstProcessingTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFirstProcessingTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setFirstProcessingTime(null);
      }
    }
    if(map.containsKey("temporary_conclusion_time")) {
      Object obj = map.get("temporary_conclusion_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTemporaryConclusionTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setTemporaryConclusionTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTemporaryConclusionTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTemporaryConclusionTime(null);
      }
    }
    if(map.containsKey("total_hours")) {
      Object obj = map.get("total_hours");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTotalHours((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalHours(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalHours(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtCreate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDealStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applying_order_status")) {
      Object obj = map.get("applying_order_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyingOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_amount")) {
      Object obj = map.get("check_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCheckAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCheckAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCheckAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCheckAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bussiness_unit_name")) {
      Object obj = map.get("bussiness_unit_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBussinessUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("account_period")) {
      Object obj = map.get("account_period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("jd_id")) {
      Object obj = map.get("jd_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJdId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("acq_bill_date")) {
      Object obj = map.get("acq_bill_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAcqBillDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAcqBillDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAcqBillDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAcqBillDate(null);
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jd_tenant_code")) {
      Object obj = map.get("jd_tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJdTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ticket_no")) {
      Object obj = map.get("ticket_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTicketNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customer_expectation")) {
      Object obj = map.get("customer_expectation");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerExpectation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ticket_status")) {
      Object obj = map.get("ticket_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTicketStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("primary_application_reason")) {
      Object obj = map.get("primary_application_reason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPrimaryApplicationReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("secondary_application_reason")) {
      Object obj = map.get("secondary_application_reason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSecondaryApplicationReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("problem_desc")) {
      Object obj = map.get("problem_desc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProblemDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("return_way")) {
      Object obj = map.get("return_way");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnWay((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("apply_time")) {
      Object obj = map.get("apply_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setApplyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setApplyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setApplyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setApplyTime(null);
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_type")) {
      Object obj = map.get("order_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("outbound_status")) {
      Object obj = map.get("outbound_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOutboundStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ordering_account")) {
      Object obj = map.get("ordering_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderingAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("product_code")) {
      Object obj = map.get("product_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("product_name")) {
      Object obj = map.get("product_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("product_amount")) {
      Object obj = map.get("product_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setProductAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setProductAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setProductAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setProductAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setProductAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("qty")) {
      Object obj = map.get("qty");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setQty((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setQty(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setQty(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("review_result")) {
      Object obj = map.get("review_result");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReviewResult((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("review_time")) {
      Object obj = map.get("review_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setReviewTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setReviewTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReviewTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setReviewTime(null);
      }
    }
    if(map.containsKey("review_opinion")) {
      Object obj = map.get("review_opinion");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReviewOpinion((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reviewer_name")) {
      Object obj = map.get("reviewer_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReviewerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pickup_time")) {
      Object obj = map.get("pickup_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPickupTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPickupTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPickupTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPickupTime(null);
      }
    }
    if(map.containsKey("pickup_status")) {
      Object obj = map.get("pickup_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPickupStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shipping_time")) {
      Object obj = map.get("shipping_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setShippingTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setShippingTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setShippingTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setShippingTime(null);
      }
    }
    if(map.containsKey("shipping_number")) {
      Object obj = map.get("shipping_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShippingNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shipping_fee")) {
      Object obj = map.get("shipping_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setShippingFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setShippingFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setShippingFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setShippingFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setShippingFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("courier_company")) {
      Object obj = map.get("courier_company");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCourierCompany((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("merchant_receipt_time")) {
      Object obj = map.get("merchant_receipt_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setMerchantReceiptTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setMerchantReceiptTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setMerchantReceiptTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setMerchantReceiptTime(null);
      }
    }
    if(map.containsKey("receipt_reason")) {
      Object obj = map.get("receipt_reason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiptReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiver")) {
      Object obj = map.get("receiver");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiver((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("processing_result")) {
      Object obj = map.get("processing_result");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcessingResult((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("processor")) {
      Object obj = map.get("processor");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcessor((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refund_amount")) {
      Object obj = map.get("refund_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRefundAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRefundAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRefundAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRefundAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRefundAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("replacement_order")) {
      Object obj = map.get("replacement_order");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReplacementOrder((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("replacement_product_code")) {
      Object obj = map.get("replacement_product_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReplacementProductCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("automatic_review_type")) {
      Object obj = map.get("automatic_review_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAutomaticReviewType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_flash_return")) {
      Object obj = map.get("is_flash_return");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsFlashReturn((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("first_review_time")) {
      Object obj = map.get("first_review_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setFirstReviewTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setFirstReviewTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setFirstReviewTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setFirstReviewTime(null);
      }
    }
    if(map.containsKey("first_processing_time")) {
      Object obj = map.get("first_processing_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setFirstProcessingTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setFirstProcessingTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setFirstProcessingTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setFirstProcessingTime(null);
      }
    }
    if(map.containsKey("temporary_conclusion_time")) {
      Object obj = map.get("temporary_conclusion_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTemporaryConclusionTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setTemporaryConclusionTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTemporaryConclusionTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setTemporaryConclusionTime(null);
      }
    }
    if(map.containsKey("total_hours")) {
      Object obj = map.get("total_hours");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTotalHours((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalHours(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalHours(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGmtCreate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDealStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataMD5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorMsg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applying_order_status")) {
      Object obj = map.get("applying_order_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyingOrderStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("check_amount")) {
      Object obj = map.get("check_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCheckAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCheckAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCheckAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCheckAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCheckAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bussiness_unit_name")) {
      Object obj = map.get("bussiness_unit_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBussinessUnitName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLatest(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("account_period")) {
      Object obj = map.get("account_period");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountPeriod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
