package com.xforceplus.ultraman.app.policymanagement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-11-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Zhangwuguanli implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 流水号
   */
  private String serialNo;

  /**
   * 业务单据号
   */
  private String orderNo;

  /**
   * 创建方式
   */
  private String creatingSource;

  /**
   * 对账平台单据类型
   */
  private String documentsType;

  /**
   * EBS单据类型
   */
  private String ebsDocumentsType;

  /**
   * 会计账期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime collection;

  /**
   * 创建日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime documentCreateTime;

  /**
   * 记账日期
   */
  private String enteringTime;

  /**
   * 记账状态
   */
  private String billingStatus;

  /**
   * 凭证号
   */
  private String voucherNo;

  /**
   * 扩展字段1
   */
  private String zhangwuext1;

  /**
   * 扩展字段2
   */
  private String zhangwuext2;

  /**
   * 扩展字段3
   */
  private String zhangwuext3;

  /**
   * 扩展字段4
   */
  private String zhangwuext4;

  /**
   * 扩展字段5
   */
  private String zhangwuext5;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 扩展字段6
   */
  private BigDecimal zhangwuext6;

  /**
   * 扩展字段7
   */
  private BigDecimal zhangwuext7;

  /**
   * 扩展字段8
   */
  private BigDecimal zhangwuext8;

  /**
   * 扩展字段9
   */
  private String zhangwuext9;

  /**
   * 扩展字段10
   */
  private String zhangwuext10;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("serial_no", serialNo);
      map.put("order_no", orderNo);
      map.put("creating_source", creatingSource);
      map.put("documents_type", documentsType);
      map.put("ebs_documents_type", ebsDocumentsType);
      map.put("collection", BocpGenUtils.toTimestamp(collection));
      map.put("document_create_time", BocpGenUtils.toTimestamp(documentCreateTime));
      map.put("entering_time", enteringTime);
      map.put("billing_status", billingStatus);
      map.put("voucher_no", voucherNo);
      map.put("zhangwuext_1", zhangwuext1);
      map.put("zhangwuext_2", zhangwuext2);
      map.put("zhangwuext_3", zhangwuext3);
      map.put("zhangwuext_4", zhangwuext4);
      map.put("zhangwuext_5", zhangwuext5);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("zhangwuext_6", zhangwuext6);
      map.put("zhangwuext_7", zhangwuext7);
      map.put("zhangwuext_8", zhangwuext8);
      map.put("zhangwuext_9", zhangwuext9);
      map.put("zhangwuext_10", zhangwuext10);

      return map;
  }

  public static Zhangwuguanli fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Zhangwuguanli entity = new Zhangwuguanli();
    if(map.containsKey("serial_no")) {
      Object obj = map.get("serial_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSerialNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("creating_source")) {
      Object obj = map.get("creating_source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreatingSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documents_type")) {
      Object obj = map.get("documents_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentsType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ebs_documents_type")) {
      Object obj = map.get("ebs_documents_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEbsDocumentsType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collection")) {
      Object obj = map.get("collection");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCollection(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCollection((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCollection(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCollection(null);
      }
    }
    if(map.containsKey("document_create_time")) {
      Object obj = map.get("document_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDocumentCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDocumentCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDocumentCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDocumentCreateTime(null);
      }
    }
    if(map.containsKey("entering_time")) {
      Object obj = map.get("entering_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEnteringTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billing_status")) {
      Object obj = map.get("billing_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillingStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("voucher_no")) {
      Object obj = map.get("voucher_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zhangwuext_1")) {
      Object obj = map.get("zhangwuext_1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZhangwuext1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zhangwuext_2")) {
      Object obj = map.get("zhangwuext_2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZhangwuext2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zhangwuext_3")) {
      Object obj = map.get("zhangwuext_3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZhangwuext3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zhangwuext_4")) {
      Object obj = map.get("zhangwuext_4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZhangwuext4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zhangwuext_5")) {
      Object obj = map.get("zhangwuext_5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZhangwuext5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zhangwuext_6")) {
      Object obj = map.get("zhangwuext_6");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setZhangwuext6((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setZhangwuext6(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setZhangwuext6(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setZhangwuext6(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setZhangwuext6(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("zhangwuext_7")) {
      Object obj = map.get("zhangwuext_7");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setZhangwuext7((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setZhangwuext7(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setZhangwuext7(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setZhangwuext7(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setZhangwuext7(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("zhangwuext_8")) {
      Object obj = map.get("zhangwuext_8");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setZhangwuext8((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setZhangwuext8(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setZhangwuext8(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setZhangwuext8(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setZhangwuext8(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("zhangwuext_9")) {
      Object obj = map.get("zhangwuext_9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZhangwuext9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zhangwuext_10")) {
      Object obj = map.get("zhangwuext_10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZhangwuext10((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("serial_no")) {
      Object obj = map.get("serial_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSerialNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("creating_source")) {
      Object obj = map.get("creating_source");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreatingSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("documents_type")) {
      Object obj = map.get("documents_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumentsType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ebs_documents_type")) {
      Object obj = map.get("ebs_documents_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEbsDocumentsType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collection")) {
      Object obj = map.get("collection");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCollection(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCollection((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCollection(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCollection(null);
      }
    }
    if(map.containsKey("document_create_time")) {
      Object obj = map.get("document_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDocumentCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDocumentCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDocumentCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDocumentCreateTime(null);
      }
    }
    if(map.containsKey("entering_time")) {
      Object obj = map.get("entering_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEnteringTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billing_status")) {
      Object obj = map.get("billing_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillingStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("voucher_no")) {
      Object obj = map.get("voucher_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVoucherNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zhangwuext_1")) {
      Object obj = map.get("zhangwuext_1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZhangwuext1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zhangwuext_2")) {
      Object obj = map.get("zhangwuext_2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZhangwuext2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zhangwuext_3")) {
      Object obj = map.get("zhangwuext_3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZhangwuext3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zhangwuext_4")) {
      Object obj = map.get("zhangwuext_4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZhangwuext4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zhangwuext_5")) {
      Object obj = map.get("zhangwuext_5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZhangwuext5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zhangwuext_6")) {
      Object obj = map.get("zhangwuext_6");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setZhangwuext6((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setZhangwuext6(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setZhangwuext6(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setZhangwuext6(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setZhangwuext6(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("zhangwuext_7")) {
      Object obj = map.get("zhangwuext_7");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setZhangwuext7((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setZhangwuext7(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setZhangwuext7(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setZhangwuext7(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setZhangwuext7(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("zhangwuext_8")) {
      Object obj = map.get("zhangwuext_8");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setZhangwuext8((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setZhangwuext8(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setZhangwuext8(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setZhangwuext8(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setZhangwuext8(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("zhangwuext_9")) {
      Object obj = map.get("zhangwuext_9");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZhangwuext9((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zhangwuext_10")) {
      Object obj = map.get("zhangwuext_10");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZhangwuext10((String)obj);
        }
      } else {
      }
    }
  }
}
