package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * data_source
 * </p>
 *
 * @author ultraman
 * @since 2024-11-25
 */
public enum DataSource {

    AAA("aaa", "系统来源1"),
    BBB("bbb", "系统来源2");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DataSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DataSource fromCode(String code){
        switch(code) {
            case "aaa":
                return AAA;
            case "bbb":
                return BBB;
            default:
                return null;
        }
    }
}
