package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_after_sale_refund_type
 * </p>
 *
 * @author ultraman
 * @since 2024-11-25
 */
public enum DyAfterSaleRefundType {

    _0("0", "订单货款/原路退款"),
    _1("1", "货到付款线下退款"),
    _2("2", "备用金"),
    _3("3", "保证金"),
    _4("4", "无需退款"),
    _5("5", "平台垫付"),
    __1("-1", "历史数据");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DyAfterSaleRefundType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyAfterSaleRefundType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "-1":
                return __1;
            default:
                return null;
        }
    }
}
