package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_pay_type
 * </p>
 *
 * @author ultraman
 * @since 2024-11-25
 */
public enum DyPayType {

    _0("0", "货到付款"),
    _1("1", "微信"),
    _2("2", "支付宝"),
    _3("3", "小程序"),
    _4("4", "银行卡"),
    _5("5", "余额"),
    _7("7", "无需支付（0元单）"),
    _8("8", "DOU分期（信用支付）"),
    _9("9", "新卡支付"),
    _12("12", "先用后付"),
    _16("16", "收银台支付");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DyPayType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyPayType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "12":
                return _12;
            case "16":
                return _16;
            default:
                return null;
        }
    }
}
