package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_trade_type
 * </p>
 *
 * @author ultraman
 * @since 2024-11-25
 */
public enum DyTradeType {

    _0("0", "普通"),
    _1("1", "拼团"),
    _2("2", "定金预售"),
    _3("3", "定金找货"),
    _4("4", "拍卖"),
    _5("5", "0元单"),
    _6("6", "回收"),
    _7("7", "寄卖"),
    _10("10", "寄样"),
    _11("11", "零元抽奖"),
    _12("12", "达人买样"),
    _13("13", "普通定制"),
    _16("16", "大众竞拍"),
    _18("18", "小时达"),
    _102("102", "定金预售的赠品单"),
    _103("103", "收款");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DyTradeType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyTradeType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "16":
                return _16;
            case "18":
                return _18;
            case "102":
                return _102;
            case "103":
                return _103;
            default:
                return null;
        }
    }
}
