package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ebs_documents_type
 * </p>
 *
 * @author ultraman
 * @since 2024-11-25
 */
public enum EbsDocumentsType {

    _1("1", "销售订单"),
    _2("2", "退货订单"),
    _3("3", "收款单"),
    _4("4", "其他业务收入"),
    _5("5", "费用"),
    _6("6", "其他"),
    _7("7", "收款单（合同负债）");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    EbsDocumentsType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EbsDocumentsType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            default:
                return null;
        }
    }
}
