package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * oms_after_sale_trade_status
 * </p>
 *
 * @author ultraman
 * @since 2024-11-25
 */
public enum OmsAfterSaleTradeStatus {

    _0("0", "待收货"),
    _1("1", "待结算"),
    _2("2", "被取消"),
    _3("3", "已完成"),
    _4("4", "待审核");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    OmsAfterSaleTradeStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OmsAfterSaleTradeStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
