package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * sale_return_status
 * </p>
 *
 * @author ultraman
 * @since 2024-11-25
 */
public enum SaleReturnStatus {

    _0("0", "销售"),
    _1("1", "售后"),
    __1("-1", "--");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SaleReturnStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SaleReturnStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "-1":
                return __1;
            default:
                return null;
        }
    }
}
