package com.xforceplus.ultraman.app.policymanagement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-11-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Accountingpolicydetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * EBS单据类型
   */
  private String ebsDocumentsType;

  /**
   * 收款方法ID
   */
  private String receivingMethod;

  /**
   * 分摊收入的赠品类型
   */
  private String giftTime;

  /**
   * 分摊的商品基准价格
   */
  private String goodsPrice;

  /**
   * 找不到是否采用默认价
   */
  private String defaultPrice;

  /**
   * 默认价格字段
   */
  private String priceType;

  /**
   * 扩展字段1
   */
  private String celueext1;

  /**
   * 扩展字段2
   */
  private String celueext2;

  /**
   * 扩展字段3
   */
  private String celueext3;

  /**
   * 扩展字段4
   */
  private String celueext4;

  /**
   * 扩展字段5
   */
  private String celueext5;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 备注
   */
  private String remark;

  /**
   * 记账科目
   */
  private String accounts;

  /**
   * 绝对值正负数
   */
  private String positiveNegative;


  /**
   * 对一关联关系 关联对象 accountingpolicy
   */
    private Long accountingpolicyReltaionId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("ebs_documents_type", ebsDocumentsType);
      map.put("receiving_method", receivingMethod);
      map.put("gift_time", giftTime);
      map.put("goods_price", goodsPrice);
      map.put("default_price", defaultPrice);
      map.put("price_type", priceType);
      map.put("celueext_1", celueext1);
      map.put("celueext_2", celueext2);
      map.put("celueext_3", celueext3);
      map.put("celueext_4", celueext4);
      map.put("celueext_5", celueext5);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("remark", remark);
      map.put("accounts", accounts);
      map.put("positive_negative", positiveNegative);

       map.put("accountingpolicyReltaion.id", accountingpolicyReltaionId);
      return map;
  }

  public static Accountingpolicydetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Accountingpolicydetail entity = new Accountingpolicydetail();
    if(map.containsKey("ebs_documents_type")) {
      Object obj = map.get("ebs_documents_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEbsDocumentsType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiving_method")) {
      Object obj = map.get("receiving_method");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceivingMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gift_time")) {
      Object obj = map.get("gift_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGiftTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_price")) {
      Object obj = map.get("goods_price");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("default_price")) {
      Object obj = map.get("default_price");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDefaultPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("price_type")) {
      Object obj = map.get("price_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPriceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("celueext_1")) {
      Object obj = map.get("celueext_1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCelueext1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("celueext_2")) {
      Object obj = map.get("celueext_2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCelueext2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("celueext_3")) {
      Object obj = map.get("celueext_3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCelueext3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("celueext_4")) {
      Object obj = map.get("celueext_4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCelueext4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("celueext_5")) {
      Object obj = map.get("celueext_5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCelueext5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accounts")) {
      Object obj = map.get("accounts");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccounts((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("positive_negative")) {
      Object obj = map.get("positive_negative");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPositiveNegative((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("accountingpolicyReltaion.id")) {
        Object obj = map.get("accountingpolicyReltaion.id");
      if(obj instanceof Long) {
        entity.setAccountingpolicyReltaionId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setAccountingpolicyReltaionId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("ebs_documents_type")) {
      Object obj = map.get("ebs_documents_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEbsDocumentsType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiving_method")) {
      Object obj = map.get("receiving_method");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceivingMethod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gift_time")) {
      Object obj = map.get("gift_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGiftTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_price")) {
      Object obj = map.get("goods_price");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsPrice((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("default_price")) {
      Object obj = map.get("default_price");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDefaultPrice((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("price_type")) {
      Object obj = map.get("price_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPriceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("celueext_1")) {
      Object obj = map.get("celueext_1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCelueext1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("celueext_2")) {
      Object obj = map.get("celueext_2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCelueext2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("celueext_3")) {
      Object obj = map.get("celueext_3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCelueext3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("celueext_4")) {
      Object obj = map.get("celueext_4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCelueext4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("celueext_5")) {
      Object obj = map.get("celueext_5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCelueext5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("accounts")) {
      Object obj = map.get("accounts");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccounts((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("positive_negative")) {
      Object obj = map.get("positive_negative");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPositiveNegative((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("accountingpolicyReltaion.id")) {
        Object obj = map.get("accountingpolicyReltaion.id");
        if(obj instanceof Long) {
          this.setAccountingpolicyReltaionId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAccountingpolicyReltaionId(Long.parseLong((String)obj));
        }
      }
  }
}
