package com.xforceplus.ultraman.app.policymanagement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 应收对账结果
 * </p>
 *
 * @author ultraman
 * @since 2024-11-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ReceivableCheckResult implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 对账结果业务主键
   */
  private String resultMd5;

  /**
   * 电商平台
   */
  private String ecChannel;

  /**
   * 电商平台店铺id
   */
  private String storeId;

  /**
   * 组织ID
   */
  private Long orgId;

  /**
   * 电商平台店铺名称
   */
  private String storeName;

  /**
   * 对账日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime checkTime;

  /**
   * 对账差异金额
   */
  private BigDecimal checkDiffAmount;

  /**
   * 对账状态
   */
  private String checkStatus;

  /**
   * 对账结果
   */
  private String checkResult;

  /**
   * 对账策略id
   */
  private String checkConfigId;

  /**
   * 应收业务类型（0：收；1：退）
   */
  private String receivableBusinessType;

  /**
   * 结算单金额
   */
  private BigDecimal settlementAmount;

  /**
   * 应收订单金额
   */
  private BigDecimal receivableOrderAmount;

  /**
   * 应收订单id
   */
  private Long receivableOrderId;

  /**
   * 应收订单编号
   */
  private String receivableOrderNo;

  /**
   * 应收订单日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime receivableOrderCreateTime;

  /**
   * 应收订单关联电商订单id
   */
  private Long receivableStoreOrderId;

  /**
   * 应收订单关联电商订单编号
   */
  private String receivableStoreOrderNo;

  /**
   * 应收调整单id
   */
  private Long receivableAdjustOrderId;

  /**
   * 应收调整单编号
   */
  private String receivableAdjustOrderNo;

  /**
   * 应收调整单创建日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime receivableAdjustOrderCreateTime;

  /**
   * 应收调整单金额
   */
  private BigDecimal receivableAdjustOrderAmount;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 白药事业部
   */
  private String businessUnit;

  /**
   * 白药公司
   */
  private String companyName;

  /**
   * 错误信息
   */
  private String errorMsg;

  /**
   * 应收调整单作废状态
   */
  private String receivableAdjustCancelStatus;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("result_md5", resultMd5);
      map.put("ec_channel", ecChannel);
      map.put("store_id", storeId);
      map.put("org_id", orgId);
      map.put("store_name", storeName);
      map.put("check_time", BocpGenUtils.toTimestamp(checkTime));
      map.put("check_diff_amount", checkDiffAmount);
      map.put("check_status", checkStatus);
      map.put("check_result", checkResult);
      map.put("check_config_id", checkConfigId);
      map.put("receivable_business_type", receivableBusinessType);
      map.put("settlement_amount", settlementAmount);
      map.put("receivable_order_amount", receivableOrderAmount);
      map.put("receivable_order_id", receivableOrderId);
      map.put("receivable_order_no", receivableOrderNo);
      map.put("receivable_order_create_time", BocpGenUtils.toTimestamp(receivableOrderCreateTime));
      map.put("receivable_store_order_id", receivableStoreOrderId);
      map.put("receivable_store_order_no", receivableStoreOrderNo);
      map.put("receivable_adjust_order_id", receivableAdjustOrderId);
      map.put("receivable_adjust_order_no", receivableAdjustOrderNo);
      map.put("receivable_adjust_order_create_time", BocpGenUtils.toTimestamp(receivableAdjustOrderCreateTime));
      map.put("receivable_adjust_order_amount", receivableAdjustOrderAmount);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("business_unit", businessUnit);
      map.put("company_name", companyName);
      map.put("error_msg", errorMsg);
      map.put("receivable_adjust_cancel_status", receivableAdjustCancelStatus);

      return map;
  }

  public static ReceivableCheckResult fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ReceivableCheckResult entity = new ReceivableCheckResult();
    if(map.containsKey("result_md5")) {
      Object obj = map.get("result_md5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setResultMd5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ec_channel")) {
      Object obj = map.get("ec_channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEcChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("store_name")) {
      Object obj = map.get("store_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_time")) {
      Object obj = map.get("check_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCheckTime(null);
      }
    }
    if(map.containsKey("check_diff_amount")) {
      Object obj = map.get("check_diff_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCheckDiffAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCheckDiffAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCheckDiffAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckDiffAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCheckDiffAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("check_status")) {
      Object obj = map.get("check_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_result")) {
      Object obj = map.get("check_result");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckResult((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_config_id")) {
      Object obj = map.get("check_config_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckConfigId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivable_business_type")) {
      Object obj = map.get("receivable_business_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceivableBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_amount")) {
      Object obj = map.get("settlement_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSettlementAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSettlementAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSettlementAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSettlementAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSettlementAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("receivable_order_amount")) {
      Object obj = map.get("receivable_order_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReceivableOrderAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReceivableOrderAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReceivableOrderAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceivableOrderAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceivableOrderAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("receivable_order_id")) {
      Object obj = map.get("receivable_order_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceivableOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceivableOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceivableOrderId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("receivable_order_no")) {
      Object obj = map.get("receivable_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceivableOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivable_order_create_time")) {
      Object obj = map.get("receivable_order_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceivableOrderCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setReceivableOrderCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceivableOrderCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReceivableOrderCreateTime(null);
      }
    }
    if(map.containsKey("receivable_store_order_id")) {
      Object obj = map.get("receivable_store_order_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceivableStoreOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceivableStoreOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceivableStoreOrderId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("receivable_store_order_no")) {
      Object obj = map.get("receivable_store_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceivableStoreOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivable_adjust_order_id")) {
      Object obj = map.get("receivable_adjust_order_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceivableAdjustOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceivableAdjustOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceivableAdjustOrderId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("receivable_adjust_order_no")) {
      Object obj = map.get("receivable_adjust_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceivableAdjustOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivable_adjust_order_create_time")) {
      Object obj = map.get("receivable_adjust_order_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceivableAdjustOrderCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setReceivableAdjustOrderCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceivableAdjustOrderCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReceivableAdjustOrderCreateTime(null);
      }
    }
    if(map.containsKey("receivable_adjust_order_amount")) {
      Object obj = map.get("receivable_adjust_order_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReceivableAdjustOrderAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReceivableAdjustOrderAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReceivableAdjustOrderAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceivableAdjustOrderAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceivableAdjustOrderAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_unit")) {
      Object obj = map.get("business_unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivable_adjust_cancel_status")) {
      Object obj = map.get("receivable_adjust_cancel_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceivableAdjustCancelStatus((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("result_md5")) {
      Object obj = map.get("result_md5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setResultMd5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ec_channel")) {
      Object obj = map.get("ec_channel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEcChannel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrgId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("store_name")) {
      Object obj = map.get("store_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("check_time")) {
      Object obj = map.get("check_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCheckTime(null);
      }
    }
    if(map.containsKey("check_diff_amount")) {
      Object obj = map.get("check_diff_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCheckDiffAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCheckDiffAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCheckDiffAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCheckDiffAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCheckDiffAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("check_status")) {
      Object obj = map.get("check_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("check_result")) {
      Object obj = map.get("check_result");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckResult((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("check_config_id")) {
      Object obj = map.get("check_config_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckConfigId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receivable_business_type")) {
      Object obj = map.get("receivable_business_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceivableBusinessType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlement_amount")) {
      Object obj = map.get("settlement_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSettlementAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSettlementAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSettlementAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSettlementAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSettlementAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("receivable_order_amount")) {
      Object obj = map.get("receivable_order_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setReceivableOrderAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setReceivableOrderAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setReceivableOrderAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReceivableOrderAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setReceivableOrderAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("receivable_order_id")) {
      Object obj = map.get("receivable_order_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setReceivableOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReceivableOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setReceivableOrderId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("receivable_order_no")) {
      Object obj = map.get("receivable_order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceivableOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receivable_order_create_time")) {
      Object obj = map.get("receivable_order_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setReceivableOrderCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setReceivableOrderCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReceivableOrderCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setReceivableOrderCreateTime(null);
      }
    }
    if(map.containsKey("receivable_store_order_id")) {
      Object obj = map.get("receivable_store_order_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setReceivableStoreOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReceivableStoreOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setReceivableStoreOrderId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("receivable_store_order_no")) {
      Object obj = map.get("receivable_store_order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceivableStoreOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receivable_adjust_order_id")) {
      Object obj = map.get("receivable_adjust_order_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setReceivableAdjustOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReceivableAdjustOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setReceivableAdjustOrderId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("receivable_adjust_order_no")) {
      Object obj = map.get("receivable_adjust_order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceivableAdjustOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receivable_adjust_order_create_time")) {
      Object obj = map.get("receivable_adjust_order_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setReceivableAdjustOrderCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setReceivableAdjustOrderCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReceivableAdjustOrderCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setReceivableAdjustOrderCreateTime(null);
      }
    }
    if(map.containsKey("receivable_adjust_order_amount")) {
      Object obj = map.get("receivable_adjust_order_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setReceivableAdjustOrderAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setReceivableAdjustOrderAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setReceivableAdjustOrderAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReceivableAdjustOrderAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setReceivableAdjustOrderAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_unit")) {
      Object obj = map.get("business_unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorMsg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receivable_adjust_cancel_status")) {
      Object obj = map.get("receivable_adjust_cancel_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceivableAdjustCancelStatus((String)obj);
        }
      } else {
      }
    }
  }
}
