package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_after_sale_detil_order_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-04
 */
public enum DyAfterSaleDetilOrderStatus {

    _2("2", "未发货"),
    _3("3", "已发货"),
    _5("5", "已收货或已完成"),
    _255("255", "已完成");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DyAfterSaleDetilOrderStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyAfterSaleDetilOrderStatus fromCode(String code){
        switch(code) {
            case "2":
                return _2;
            case "3":
                return _3;
            case "5":
                return _5;
            case "255":
                return _255;
            default:
                return null;
        }
    }
}
