package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_check_biz_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-04
 */
public enum DyCheckBizType {

    _0("0", "全部"),
    _1("1", "鲁班广告"),
    _2("2", "精选联盟"),
    _3("3", "值点商城"),
    _4("4", "小店自卖"),
    _5("5", "橙子建站"),
    _6("6", "POI"),
    _7("7", "抖+"),
    _8("8", "穿山甲"),
    _9("9", "服务市场"),
    _10("10", "服务市场外包客服"),
    _11("11", "学浪");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DyCheckBizType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyCheckBizType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            default:
                return null;
        }
    }
}
