package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * jky_logistic_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-04
 */
public enum JkyLogisticType {

    _1("1", "普通快递"),
    _2("2", "上门自提"),
    _3("3", "门店配送"),
    _5("5", "无需配送"),
    _6("6", "线下配送"),
    _7("7", "自有物流");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    JkyLogisticType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static JkyLogisticType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            default:
                return null;
        }
    }
}
