package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * oms_trade_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-04
 */
public enum OmsTradeStatus {

    _8("8", "发货在途"),
    _11("11", "已完成"),
    _0("0", "被取消"),
    _1("1", "等待单"),
    _2("2", "待审核"),
    _3("3", "预订单"),
    _4("4", "待结算"),
    _5("5", "打单出库"),
    _6("6", "生产等待"),
    _7("7", " 待发货"),
    _9("9", "代销发货"),
    _10("10", "委外发货"),
    _12("12", "12"),
    _13("13", "13"),
    _14("14", "14"),
    _15("15", "15"),
    _16("16", "16"),
    _17("17", "17"),
    _18("18", "18"),
    __1("-1", "未对接");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    OmsTradeStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OmsTradeStatus fromCode(String code){
        switch(code) {
            case "8":
                return _8;
            case "11":
                return _11;
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "9":
                return _9;
            case "10":
                return _10;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            case "15":
                return _15;
            case "16":
                return _16;
            case "17":
                return _17;
            case "18":
                return _18;
            case "-1":
                return __1;
            default:
                return null;
        }
    }
}
