package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * tb_sales_order_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-04
 */
public enum TbSalesOrderStatus {

    _3("3", "交易关闭");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TbSalesOrderStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TbSalesOrderStatus fromCode(String code){
        switch(code) {
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
