package com.xforceplus.ultraman.app.policymanagement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-12-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ReceivableSalesOrder implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 店铺id
   */
  private String storeId;

  /**
   * 订单编号
   */
  private String orderNo;

  /**
   * 商品行id
   */
  private String goodsId;

  /**
   * 商品名称
   */
  private String goodsName;

  /**
   * 订购数量
   */
  private Long goodsNum;

  /**
   * 支付方式
   */
  private String payType;

  /**
   * 订单金额
   */
  private BigDecimal orderAmount;

  /**
   * 应付金额
   */
  private BigDecimal payableAmount;

  /**
   * 商家备注
   */
  private String merchantRemark;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 订单备注
   */
  private String orderRemark;

  /**
   * 运费金额
   */
  private BigDecimal freight;

  /**
   * 市
   */
  private String city;

  /**
   * 运单号
   */
  private String logisticsNo;

  /**
   * 物流公司
   */
  private String logisticsCompany;

  /**
   * 付款时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime orderPayTime;

  /**
   * 订单唯一ID
   */
  private String rcId;

  /**
   * 价格
   */
  private BigDecimal goodsPrice;

  /**
   * 省份
   */
  private String province;

  /**
   * 区乡镇
   */
  private String town;

  /**
   * 商家帐号
   */
  private String sellerAccount;

  /**
   * 买家账号
   */
  private String buyerAccount;

  /**
   * 卖家昵称
   */
  private String sellerNick;

  /**
   * 买家昵称
   */
  private String buyerNick;

  /**
   * 店铺名称
   */
  private String storeName;

  /**
   * 达人/团长ID
   */
  private String groupId;

  /**
   * 达人/团长昵称
   */
  private String groupNick;

  /**
   * 父订单号
   */
  private String parentOrderNo;

  /**
   * 商品金额
   */
  private BigDecimal goodsAmount;

  /**
   * 实付金额
   */
  private BigDecimal payAmount;

  /**
   * 商品编码
   */
  private String skuId;

  /**
   * 商品原金额
   */
  private BigDecimal originAmount;

  /**
   * 商品折后金额
   */
  private BigDecimal sumAmount;

  /**
   * 商品折扣
   */
  private BigDecimal discountFee;

  /**
   * 物流方式
   */
  private String logisticsType;

  /**
   * 退款状态
   */
  private String refundStatus;

  /**
   * 售后状态
   */
  private String afterSaleStatus;

  /**
   * 电商渠道
   */
  private String ecChannel;

  /**
   * 订单状态
   */
  private String orderStatus;

  /**
   * 订单类型
   */
  private String orderType;

  /**
   * 业务ID
   */
  private String businessId;

  /**
   * 数据MD5
   */
  @TableField("dataMD5")
  private String dataMD5;

  /**
   * 单据流转状态
   */
  private String dealStatus;

  /**
   * 应收订单类型
   */
  private String rcOrderType;

  /**
   * 对账状态
   */
  @TableField("checkStatus")
  private String checkStatus;

  /**
   * 核销金额
   */
  private BigDecimal verificationAmount;

  /**
   * 发票号码
   */
  private String invoiceNo;

  /**
   * EBS回传状态
   */
  private String ebsBackStatus;

  /**
   * 异常信息
   */
  private String errorMsg;

  /**
   * 交易修改时间
   */
  private String updatedAt;

  /**
   * 订单完成时间
   */
  private String orderFinishTime;

  /**
   * 确认收货时间
   */
  private String receiveTime;

  /**
   * 作废状态
   */
  private String cancelStatus;

  /**
   * 账期
   */
  private String accountPeriod;

  /**
   * 汇总日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime summaryDate;

  /**
   * 汇总单编号
   */
  private String summaryNo;

  /**
   * 最新版本
   */
  private Boolean latest;

  /**
   * 版本号
   */
  @TableField("versionNo")
  private String versionNo;

  /**
   * 人工备注
   */
  @TableField("manualRemark")
  private String manualRemark;

  /**
   * 下单时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime orderTime;

  /**
   * 事业部名称
   */
  private String bussinessUnitName;

  /**
   * 公司名称
   */
  private String companyName;

  /**
   * 公司税号
   */
  private String companyTaxNo;

  /**
   * 数据来源类型
   */
  private String dataResourceType;

  /**
   * 对账金额
   */
  private BigDecimal checkAmount;

  /**
   * 销退类型
   */
  private String saleReturnType;

  /**
   * 核销对账状态
   */
  private String vrStatus;

  /**
   * 核销状态
   */
  @TableField("verification_Status")
  private String verificationStatus;

  /**
   * 原应收订单ID
   */
  private Long orignRcId;

  /**
   * oms 订单id
   */
  private String omsIds;

  /**
   * oms平台
   */
  private String omsType;

  /**
   * 组织树
   */
  private String orgTree;


  /**
   * 对一关联关系 关联对象 receivableStatisticsDay
   */
    private Long summaryId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("store_id", storeId);
      map.put("order_no", orderNo);
      map.put("goods_id", goodsId);
      map.put("goods_name", goodsName);
      map.put("goods_num", goodsNum);
      map.put("pay_type", payType);
      map.put("order_amount", orderAmount);
      map.put("payable_amount", payableAmount);
      map.put("merchant_remark", merchantRemark);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("order_remark", orderRemark);
      map.put("freight", freight);
      map.put("city", city);
      map.put("logistics_no", logisticsNo);
      map.put("logistics_company", logisticsCompany);
      map.put("order_pay_time", BocpGenUtils.toTimestamp(orderPayTime));
      map.put("rc_id", rcId);
      map.put("goods_price", goodsPrice);
      map.put("province", province);
      map.put("town", town);
      map.put("seller_account", sellerAccount);
      map.put("buyer_account", buyerAccount);
      map.put("seller_nick", sellerNick);
      map.put("buyer_nick", buyerNick);
      map.put("store_name", storeName);
      map.put("group_id", groupId);
      map.put("group_nick", groupNick);
      map.put("parent_order_no", parentOrderNo);
      map.put("goods_amount", goodsAmount);
      map.put("pay_amount", payAmount);
      map.put("sku_id", skuId);
      map.put("origin_amount", originAmount);
      map.put("sum_amount", sumAmount);
      map.put("discount_fee", discountFee);
      map.put("logistics_type", logisticsType);
      map.put("refund_status", refundStatus);
      map.put("after_sale_status", afterSaleStatus);
      map.put("ec_channel", ecChannel);
      map.put("order_status", orderStatus);
      map.put("order_type", orderType);
      map.put("business_id", businessId);
      map.put("dataMD5", dataMD5);
      map.put("deal_status", dealStatus);
      map.put("rc_order_type", rcOrderType);
      map.put("checkStatus", checkStatus);
      map.put("verification_amount", verificationAmount);
      map.put("invoice_no", invoiceNo);
      map.put("ebs_back_status", ebsBackStatus);
      map.put("error_msg", errorMsg);
      map.put("updated_at", updatedAt);
      map.put("order_finish_time", orderFinishTime);
      map.put("receive_time", receiveTime);
      map.put("cancel_status", cancelStatus);
      map.put("account_period", accountPeriod);
      map.put("summary_date", BocpGenUtils.toTimestamp(summaryDate));
      map.put("summary_no", summaryNo);
      map.put("latest", latest);
      map.put("versionNo", versionNo);
      map.put("manualRemark", manualRemark);
      map.put("order_time", BocpGenUtils.toTimestamp(orderTime));
      map.put("bussiness_unit_name", bussinessUnitName);
      map.put("company_name", companyName);
      map.put("company_tax_no", companyTaxNo);
      map.put("data_resource_type", dataResourceType);
      map.put("check_amount", checkAmount);
      map.put("sale_return_type", saleReturnType);
      map.put("vr_status", vrStatus);
      map.put("verification_Status", verificationStatus);
      map.put("orign_rc_id", orignRcId);
      map.put("oms_ids", omsIds);
      map.put("oms_type", omsType);
      map.put("org_tree", orgTree);

       map.put("summary.id", summaryId);
      return map;
  }

  public static ReceivableSalesOrder fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ReceivableSalesOrder entity = new ReceivableSalesOrder();
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_id")) {
      Object obj = map.get("goods_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_name")) {
      Object obj = map.get("goods_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_num")) {
      Object obj = map.get("goods_num");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGoodsNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGoodsNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGoodsNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("pay_type")) {
      Object obj = map.get("pay_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_amount")) {
      Object obj = map.get("order_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("payable_amount")) {
      Object obj = map.get("payable_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayableAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayableAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayableAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayableAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayableAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("merchant_remark")) {
      Object obj = map.get("merchant_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMerchantRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_remark")) {
      Object obj = map.get("order_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freight")) {
      Object obj = map.get("freight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFreight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFreight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFreight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFreight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFreight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("city")) {
      Object obj = map.get("city");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistics_no")) {
      Object obj = map.get("logistics_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistics_company")) {
      Object obj = map.get("logistics_company");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticsCompany((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_pay_time")) {
      Object obj = map.get("order_pay_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderPayTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setOrderPayTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderPayTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOrderPayTime(null);
      }
    }
    if(map.containsKey("rc_id")) {
      Object obj = map.get("rc_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRcId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_price")) {
      Object obj = map.get("goods_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGoodsPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGoodsPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGoodsPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGoodsPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGoodsPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("province")) {
      Object obj = map.get("province");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProvince((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("town")) {
      Object obj = map.get("town");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTown((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_account")) {
      Object obj = map.get("seller_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_account")) {
      Object obj = map.get("buyer_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_nick")) {
      Object obj = map.get("seller_nick");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerNick((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_nick")) {
      Object obj = map.get("buyer_nick");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerNick((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_name")) {
      Object obj = map.get("store_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("group_id")) {
      Object obj = map.get("group_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGroupId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("group_nick")) {
      Object obj = map.get("group_nick");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGroupNick((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("parent_order_no")) {
      Object obj = map.get("parent_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setParentOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_amount")) {
      Object obj = map.get("goods_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGoodsAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGoodsAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGoodsAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGoodsAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGoodsAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sku_id")) {
      Object obj = map.get("sku_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSkuId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_amount")) {
      Object obj = map.get("origin_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOriginAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOriginAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOriginAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOriginAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOriginAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sum_amount")) {
      Object obj = map.get("sum_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSumAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSumAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSumAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSumAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSumAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discount_fee")) {
      Object obj = map.get("discount_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("logistics_type")) {
      Object obj = map.get("logistics_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticsType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_status")) {
      Object obj = map.get("refund_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("after_sale_status")) {
      Object obj = map.get("after_sale_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAfterSaleStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ec_channel")) {
      Object obj = map.get("ec_channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEcChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_status")) {
      Object obj = map.get("order_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_type")) {
      Object obj = map.get("order_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDealStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rc_order_type")) {
      Object obj = map.get("rc_order_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRcOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verification_amount")) {
      Object obj = map.get("verification_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setVerificationAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setVerificationAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setVerificationAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setVerificationAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setVerificationAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ebs_back_status")) {
      Object obj = map.get("ebs_back_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEbsBackStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("updated_at")) {
      Object obj = map.get("updated_at");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdatedAt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_finish_time")) {
      Object obj = map.get("order_finish_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderFinishTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receive_time")) {
      Object obj = map.get("receive_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cancel_status")) {
      Object obj = map.get("cancel_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCancelStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_period")) {
      Object obj = map.get("account_period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("summary_date")) {
      Object obj = map.get("summary_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSummaryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSummaryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSummaryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSummaryDate(null);
      }
    }
    if(map.containsKey("summary_no")) {
      Object obj = map.get("summary_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSummaryNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("manualRemark")) {
      Object obj = map.get("manualRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setManualRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_time")) {
      Object obj = map.get("order_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setOrderTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOrderTime(null);
      }
    }
    if(map.containsKey("bussiness_unit_name")) {
      Object obj = map.get("bussiness_unit_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBussinessUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("data_resource_type")) {
      Object obj = map.get("data_resource_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataResourceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_amount")) {
      Object obj = map.get("check_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCheckAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCheckAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCheckAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCheckAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sale_return_type")) {
      Object obj = map.get("sale_return_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSaleReturnType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vr_status")) {
      Object obj = map.get("vr_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVrStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verification_Status")) {
      Object obj = map.get("verification_Status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVerificationStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orign_rc_id")) {
      Object obj = map.get("orign_rc_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrignRcId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrignRcId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrignRcId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("oms_ids")) {
      Object obj = map.get("oms_ids");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOmsIds((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oms_type")) {
      Object obj = map.get("oms_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOmsType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("summary.id")) {
        Object obj = map.get("summary.id");
      if(obj instanceof Long) {
        entity.setSummaryId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setSummaryId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_id")) {
      Object obj = map.get("goods_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_name")) {
      Object obj = map.get("goods_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_num")) {
      Object obj = map.get("goods_num");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGoodsNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGoodsNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setGoodsNum(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("pay_type")) {
      Object obj = map.get("pay_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_amount")) {
      Object obj = map.get("order_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOrderAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOrderAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOrderAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("payable_amount")) {
      Object obj = map.get("payable_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPayableAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPayableAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPayableAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayableAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayableAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("merchant_remark")) {
      Object obj = map.get("merchant_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMerchantRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_remark")) {
      Object obj = map.get("order_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("freight")) {
      Object obj = map.get("freight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setFreight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setFreight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setFreight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setFreight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setFreight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("city")) {
      Object obj = map.get("city");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logistics_no")) {
      Object obj = map.get("logistics_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticsNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logistics_company")) {
      Object obj = map.get("logistics_company");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticsCompany((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_pay_time")) {
      Object obj = map.get("order_pay_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderPayTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setOrderPayTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderPayTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setOrderPayTime(null);
      }
    }
    if(map.containsKey("rc_id")) {
      Object obj = map.get("rc_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRcId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_price")) {
      Object obj = map.get("goods_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setGoodsPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setGoodsPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setGoodsPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGoodsPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setGoodsPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("province")) {
      Object obj = map.get("province");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProvince((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("town")) {
      Object obj = map.get("town");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTown((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_account")) {
      Object obj = map.get("seller_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyer_account")) {
      Object obj = map.get("buyer_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_nick")) {
      Object obj = map.get("seller_nick");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerNick((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyer_nick")) {
      Object obj = map.get("buyer_nick");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerNick((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("store_name")) {
      Object obj = map.get("store_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("group_id")) {
      Object obj = map.get("group_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGroupId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("group_nick")) {
      Object obj = map.get("group_nick");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGroupNick((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("parent_order_no")) {
      Object obj = map.get("parent_order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setParentOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_amount")) {
      Object obj = map.get("goods_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setGoodsAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setGoodsAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setGoodsAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGoodsAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setGoodsAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sku_id")) {
      Object obj = map.get("sku_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSkuId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin_amount")) {
      Object obj = map.get("origin_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOriginAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOriginAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOriginAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOriginAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOriginAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sum_amount")) {
      Object obj = map.get("sum_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSumAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSumAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSumAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSumAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSumAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("discount_fee")) {
      Object obj = map.get("discount_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDiscountFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("logistics_type")) {
      Object obj = map.get("logistics_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticsType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refund_status")) {
      Object obj = map.get("refund_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefundStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("after_sale_status")) {
      Object obj = map.get("after_sale_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAfterSaleStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ec_channel")) {
      Object obj = map.get("ec_channel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEcChannel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_status")) {
      Object obj = map.get("order_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_type")) {
      Object obj = map.get("order_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataMD5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDealStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rc_order_type")) {
      Object obj = map.get("rc_order_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRcOrderType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("verification_amount")) {
      Object obj = map.get("verification_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setVerificationAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setVerificationAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setVerificationAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setVerificationAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setVerificationAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ebs_back_status")) {
      Object obj = map.get("ebs_back_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEbsBackStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorMsg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("updated_at")) {
      Object obj = map.get("updated_at");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdatedAt((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_finish_time")) {
      Object obj = map.get("order_finish_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderFinishTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receive_time")) {
      Object obj = map.get("receive_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiveTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cancel_status")) {
      Object obj = map.get("cancel_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCancelStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("account_period")) {
      Object obj = map.get("account_period");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountPeriod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("summary_date")) {
      Object obj = map.get("summary_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSummaryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSummaryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSummaryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSummaryDate(null);
      }
    }
    if(map.containsKey("summary_no")) {
      Object obj = map.get("summary_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSummaryNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLatest(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVersionNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("manualRemark")) {
      Object obj = map.get("manualRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setManualRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_time")) {
      Object obj = map.get("order_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setOrderTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setOrderTime(null);
      }
    }
    if(map.containsKey("bussiness_unit_name")) {
      Object obj = map.get("bussiness_unit_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBussinessUnitName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("data_resource_type")) {
      Object obj = map.get("data_resource_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataResourceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("check_amount")) {
      Object obj = map.get("check_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCheckAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCheckAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCheckAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCheckAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCheckAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sale_return_type")) {
      Object obj = map.get("sale_return_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSaleReturnType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vr_status")) {
      Object obj = map.get("vr_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVrStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("verification_Status")) {
      Object obj = map.get("verification_Status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVerificationStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orign_rc_id")) {
      Object obj = map.get("orign_rc_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrignRcId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrignRcId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrignRcId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("oms_ids")) {
      Object obj = map.get("oms_ids");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOmsIds((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("oms_type")) {
      Object obj = map.get("oms_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOmsType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("summary.id")) {
        Object obj = map.get("summary.id");
        if(obj instanceof Long) {
          this.setSummaryId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSummaryId(Long.parseLong((String)obj));
        }
      }
  }
}
