package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * check_result
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum CheckResult {

    _0("0", "允差外不通过"),
    _1("1", "允差内通过"),
    _2("2", "未找到电商订单"),
    _3("3", "未找到OMS订单"),
    _4("4", "未找到应收订单"),
    _5("5", "未找到结算单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CheckResult(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CheckResult fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
