package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_check_trans_scene_tag
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum DyCheckTransSceneTag {

    _0("0", "其他"),
    _1("1", "消费者赔付"),
    _2("2", "小额打款"),
    _3("3", "判罚扣款"),
    _4("4", "物流赔付"),
    _5("5", "充值保证金");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DyCheckTransSceneTag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyCheckTransSceneTag fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
