package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * platform_subsidy_deal_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum PlatformSubsidyDealStatus {

    _0("0", "草稿"),
    _1("1", "已提交"),
    _2("2", "回传中"),
    _3("3", "已记账"),
    _4("4", "作废");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PlatformSubsidyDealStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PlatformSubsidyDealStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
