package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * data_type
 * </p>
 *
 * @author ultraman
 * @since 2025-02-24
 */
public enum DataType {

    AA("aa", "单据类型1"),
    BB("bb", "单据类型2");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DataType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DataType fromCode(String code){
        switch(code) {
            case "aa":
                return AA;
            case "bb":
                return BB;
            default:
                return null;
        }
    }
}
