package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_after_sale_status
 * </p>
 *
 * @author ultraman
 * @since 2025-02-24
 */
public enum DyAfterSaleStatus {

    _6("6", "待商家同意"),
    _7("7", "待买家退货"),
    _8("8", "待商家发货"),
    _11("11", "待商家二次同意"),
    _12("12", "售后成功"),
    _13("13", "换货,补寄,维修待买家收货"),
    _14("14", "换货,补寄,维修成功"),
    _27("27", "商家一次拒绝"),
    _28("28", "售后失败"),
    _29("29", "商家二次拒绝");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DyAfterSaleStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyAfterSaleStatus fromCode(String code){
        switch(code) {
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            case "27":
                return _27;
            case "28":
                return _28;
            case "29":
                return _29;
            default:
                return null;
        }
    }
}
