package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * goods_category
 * </p>
 *
 * @author ultraman
 * @since 2025-02-24
 */
public enum GoodsCategory {

    VG("VG", "虚拟商品"),
    AG("AG", "实物商品");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    GoodsCategory(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static GoodsCategory fromCode(String code){
        switch(code) {
            case "VG":
                return VG;
            case "AG":
                return AG;
            default:
                return null;
        }
    }
}
