package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ks_co_type
 * </p>
 *
 * @author ultraman
 * @since 2025-02-24
 */
public enum KsCoType {

    _0("0", "未知"),
    _2("2", "券包"),
    _3("3", "话费充值"),
    _8("8", "跨境"),
    _24("24", "预约有价优惠券");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    KsCoType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static KsCoType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "2":
                return _2;
            case "3":
                return _3;
            case "8":
                return _8;
            case "24":
                return _24;
            default:
                return null;
        }
    }
}
