package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ksnegotiate_status
 * </p>
 *
 * @author ultraman
 * @since 2025-02-24
 */
public enum KsnegotiateStatus {

    _0("0", "未知状态"),
    _1("1", "待商家处理"),
    _2("2", "商家同意"),
    _3("3", "商家驳回，等待买家修改");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    KsnegotiateStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static KsnegotiateStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
