package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * match_type
 * </p>
 *
 * @author ultraman
 * @since 2025-02-24
 */
public enum MatchType {

    AND("and", "且"),
    OR("or", "或");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    MatchType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MatchType fromCode(String code){
        switch(code) {
            case "and":
                return AND;
            case "or":
                return OR;
            default:
                return null;
        }
    }
}
