package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pdd_after_sales_status
 * </p>
 *
 * @author ultraman
 * @since 2025-02-24
 */
public enum PddAfterSalesStatus {

    _0("0", "无售后"),
    _2("2", "买家申请退款，待商家处理"),
    _3("3", "退货退款，待商家处理 "),
    _4("4", "商家同意退款，退款中"),
    _5("5", " 平台同意退款，退款中"),
    _6("6", "驳回退款，待买家处理"),
    _7("7", "已同意退货退款,待用户发货"),
    _8("8", "平台处理中"),
    _9("9", "平台拒绝退款，退款关闭"),
    _10("10", "退款成功"),
    _11("11", "买家撤销"),
    _12("12", "买家逾期未处理，退款失败 "),
    _13("13", "买家逾期，超过有效期 "),
    _14("14", "换货补寄待商家处理"),
    _15("15", "换货补寄待用户处理"),
    _16("16", "换货补寄成功"),
    _17("17", "换货补寄失败"),
    _18("18", "换货补寄待"),
    _21("21", "待商家同意维修"),
    _22("22", "待用户确认发货"),
    _24("24", "维修关闭"),
    _25("25", "维修成功"),
    _27("27", "待用户确认收货"),
    _31("31", "已同意拒收退款，待用户拒收"),
    _32("32", "补寄待商家发货"),
    _33("33", "同意召回后退款，待商家召回");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PddAfterSalesStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PddAfterSalesStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            case "15":
                return _15;
            case "16":
                return _16;
            case "17":
                return _17;
            case "18":
                return _18;
            case "21":
                return _21;
            case "22":
                return _22;
            case "24":
                return _24;
            case "25":
                return _25;
            case "27":
                return _27;
            case "31":
                return _31;
            case "32":
                return _32;
            case "33":
                return _33;
            default:
                return null;
        }
    }
}
