package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pdd_refund_operator_role
 * </p>
 *
 * @author ultraman
 * @since 2025-02-24
 */
public enum PddRefundOperatorRole {

    _0("0", "默认"),
    _1("1", "用户"),
    _2("2", "商家"),
    _3("3", "平台"),
    _4("4", "系统"),
    _5("5", "团长"),
    _6("6", "司机"),
    _7("7", "代理人");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PddRefundOperatorRole(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PddRefundOperatorRole fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            default:
                return null;
        }
    }
}
