package com.xforceplus.ultraman.app.policymanagement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2025-02-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class DyAfterSaleDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 售后单号
   */
  private String aftersaleId;

  /**
   * 申请时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime applyTime;

  /**
   * 商品单信息
   */
  private String skuOrderId;

  /**
   * 店铺编号
   */
  private String shopId;

  /**
   * 关联的订单ID
   */
  private String relatedId;

  /**
   * 订单状态
   */
  private String orderStatus;

  /**
   * 付款金额
   */
  private BigDecimal payAmount;

  /**
   * 付运费金额
   */
  private BigDecimal postAmount;

  /**
   * 购买数量
   */
  private Long itemNum;

  /**
   * 下单时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime dyCreateTime;

  /**
   * 税费
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime taxAmount;

  /**
   * 商品ID
   */
  private String productId;

  /**
   * 规格ID
   */
  private String skuId;

  /**
   * 商品名称
   */
  private String productName;

  /**
   * 商品图片
   */
  private String productImage;

  /**
   * 商家SKU编码
   */
  private String shopSkuCode;

  /**
   * 售后退款金额
   */
  private BigDecimal aftersalePayAmount;

  /**
   * 售后退运费金额
   */
  private BigDecimal aftersalePostAmount;

  /**
   * 售后退税费金额
   */
  private BigDecimal aftersaleTaxAmount;

  /**
   * 售后商品数量
   */
  private Long aftersaleItemNum;

  /**
   * 优惠券金额
   */
  private BigDecimal promotionPayAmount;

  /**
   * 价格
   */
  private BigDecimal price;

  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtCreate;

  /**
   * 更新时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtModified;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * ID
   */
  private Long dyId;

  /**
   * 组织树
   */
  private String orgTree;


  /**
   * 对一关联关系 关联对象 dyAfterSale
   */
    private Long mainId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("aftersale_id", aftersaleId);
      map.put("apply_time", BocpGenUtils.toTimestamp(applyTime));
      map.put("sku_order_id", skuOrderId);
      map.put("shop_id", shopId);
      map.put("related_id", relatedId);
      map.put("order_status", orderStatus);
      map.put("pay_amount", payAmount);
      map.put("post_amount", postAmount);
      map.put("item_num", itemNum);
      map.put("dy_create_time", BocpGenUtils.toTimestamp(dyCreateTime));
      map.put("tax_amount", BocpGenUtils.toTimestamp(taxAmount));
      map.put("product_id", productId);
      map.put("sku_id", skuId);
      map.put("product_name", productName);
      map.put("product_image", productImage);
      map.put("shop_sku_code", shopSkuCode);
      map.put("aftersale_pay_amount", aftersalePayAmount);
      map.put("aftersale_post_amount", aftersalePostAmount);
      map.put("aftersale_tax_amount", aftersaleTaxAmount);
      map.put("aftersale_item_num", aftersaleItemNum);
      map.put("promotion_pay_amount", promotionPayAmount);
      map.put("price", price);
      map.put("gmt_create", BocpGenUtils.toTimestamp(gmtCreate));
      map.put("gmt_modified", BocpGenUtils.toTimestamp(gmtModified));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("dy_id", dyId);
      map.put("org_tree", orgTree);

       map.put("main.id", mainId);
      return map;
  }

  public static DyAfterSaleDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    DyAfterSaleDetail entity = new DyAfterSaleDetail();
    if(map.containsKey("aftersale_id")) {
      Object obj = map.get("aftersale_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAftersaleId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apply_time")) {
      Object obj = map.get("apply_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setApplyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setApplyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApplyTime(null);
      }
    }
    if(map.containsKey("sku_order_id")) {
      Object obj = map.get("sku_order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSkuOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("related_id")) {
      Object obj = map.get("related_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRelatedId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_status")) {
      Object obj = map.get("order_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("post_amount")) {
      Object obj = map.get("post_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPostAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPostAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPostAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPostAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPostAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("item_num")) {
      Object obj = map.get("item_num");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setItemNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setItemNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setItemNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("dy_create_time")) {
      Object obj = map.get("dy_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDyCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDyCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDyCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDyCreateTime(null);
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTaxAmount(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setTaxAmount((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTaxAmount(null);
      }
    }
    if(map.containsKey("product_id")) {
      Object obj = map.get("product_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sku_id")) {
      Object obj = map.get("sku_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSkuId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_name")) {
      Object obj = map.get("product_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_image")) {
      Object obj = map.get("product_image");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductImage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_sku_code")) {
      Object obj = map.get("shop_sku_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopSkuCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("aftersale_pay_amount")) {
      Object obj = map.get("aftersale_pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAftersalePayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAftersalePayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAftersalePayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAftersalePayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAftersalePayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("aftersale_post_amount")) {
      Object obj = map.get("aftersale_post_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAftersalePostAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAftersalePostAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAftersalePostAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAftersalePostAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAftersalePostAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("aftersale_tax_amount")) {
      Object obj = map.get("aftersale_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAftersaleTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAftersaleTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAftersaleTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAftersaleTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAftersaleTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("aftersale_item_num")) {
      Object obj = map.get("aftersale_item_num");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAftersaleItemNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAftersaleItemNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAftersaleItemNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("promotion_pay_amount")) {
      Object obj = map.get("promotion_pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPromotionPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPromotionPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPromotionPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPromotionPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPromotionPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("price")) {
      Object obj = map.get("price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dy_id")) {
      Object obj = map.get("dy_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("main.id")) {
        Object obj = map.get("main.id");
      if(obj instanceof Long) {
        entity.setMainId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setMainId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("aftersale_id")) {
      Object obj = map.get("aftersale_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAftersaleId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("apply_time")) {
      Object obj = map.get("apply_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setApplyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setApplyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setApplyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setApplyTime(null);
      }
    }
    if(map.containsKey("sku_order_id")) {
      Object obj = map.get("sku_order_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSkuOrderId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("related_id")) {
      Object obj = map.get("related_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRelatedId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_status")) {
      Object obj = map.get("order_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("post_amount")) {
      Object obj = map.get("post_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPostAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPostAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPostAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPostAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPostAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("item_num")) {
      Object obj = map.get("item_num");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setItemNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setItemNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setItemNum(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("dy_create_time")) {
      Object obj = map.get("dy_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDyCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDyCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDyCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDyCreateTime(null);
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTaxAmount(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setTaxAmount((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxAmount(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setTaxAmount(null);
      }
    }
    if(map.containsKey("product_id")) {
      Object obj = map.get("product_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sku_id")) {
      Object obj = map.get("sku_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSkuId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("product_name")) {
      Object obj = map.get("product_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("product_image")) {
      Object obj = map.get("product_image");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductImage((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shop_sku_code")) {
      Object obj = map.get("shop_sku_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopSkuCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("aftersale_pay_amount")) {
      Object obj = map.get("aftersale_pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAftersalePayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAftersalePayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAftersalePayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAftersalePayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAftersalePayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("aftersale_post_amount")) {
      Object obj = map.get("aftersale_post_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAftersalePostAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAftersalePostAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAftersalePostAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAftersalePostAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAftersalePostAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("aftersale_tax_amount")) {
      Object obj = map.get("aftersale_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAftersaleTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAftersaleTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAftersaleTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAftersaleTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAftersaleTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("aftersale_item_num")) {
      Object obj = map.get("aftersale_item_num");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAftersaleItemNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAftersaleItemNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setAftersaleItemNum(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("promotion_pay_amount")) {
      Object obj = map.get("promotion_pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPromotionPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPromotionPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPromotionPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPromotionPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPromotionPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("price")) {
      Object obj = map.get("price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dy_id")) {
      Object obj = map.get("dy_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setDyId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("main.id")) {
        Object obj = map.get("main.id");
        if(obj instanceof Long) {
          this.setMainId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setMainId(Long.parseLong((String)obj));
        }
      }
  }
}
