package com.xforceplus.ultraman.app.policymanagement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 网店管家OMS售后
 * </p>
 *
 * @author ultraman
 * @since 2025-02-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OmsAfterSale implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 主键
   */
  private Long omsId;

  /**
   * 单号
   */
  private String tradeNo;

  /**
   * 退换单状态
   */
  private String tradeStatus;

  /**
   * 原店铺名
   */
  private String shopName;

  /**
   * 备注
   */
  private String remark;

  /**
   * 网名
   */
  private String nickName;

  /**
   * 系统创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime omsCreateTime;

  /**
   * 系统更新时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime omsUpdateTime;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 单据流转处理状态
   */
  private String dealStatus;

  /**
   * 业务ID
   */
  private String businessId;

  /**
   * 对账状态
   */
  @TableField("checkStatus")
  private String checkStatus;

  /**
   * 数据MD5
   */
  @TableField("dataMD5")
  private String dataMD5;

  /**
   * 异常信息
   */
  private String errorMsg;

  /**
   * 最新版本
   */
  private Boolean latest;

  /**
   * 对账金额
   */
  private BigDecimal checkAmount;

  /**
   * 电商渠道
   */
  private String ecChannel;

  /**
   * 事业部名称
   */
  private String bussinessUnitName;

  /**
   * 公司名称
   */
  private String companyName;

  /**
   * 公司税号
   */
  private String companyTaxNo;

  /**
   * 获取账单日期
   */
  private String acqDate;

  /**
   * 店铺编号
   */
  private String shopId;

  /**
   * oms店铺ID
   */
  private String omsShopId;

  /**
   * 退货单号
   */
  private String refundNo;

  /**
   * 货运单号
   */
  private String postNo;

  /**
   * 货运方式
   */
  private String postWay;

  /**
   * 退货原因
   */
  private String returnReason;

  /**
   * 状态
   */
  private String status;

  /**
   * 关联退换单号
   */
  private String relTradeNo;

  /**
   * 客户
   */
  private String customerName;

  /**
   * 退货总数量
   */
  private String totalQty;

  /**
   * 关联订单原始单号
   */
  private String relOrderNo;

  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtCreate;

  /**
   * 更新时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtModified;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("oms_id", omsId);
      map.put("trade_no", tradeNo);
      map.put("trade_status", tradeStatus);
      map.put("shop_name", shopName);
      map.put("remark", remark);
      map.put("nick_name", nickName);
      map.put("oms_create_time", BocpGenUtils.toTimestamp(omsCreateTime));
      map.put("oms_update_time", BocpGenUtils.toTimestamp(omsUpdateTime));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("deal_status", dealStatus);
      map.put("business_id", businessId);
      map.put("checkStatus", checkStatus);
      map.put("dataMD5", dataMD5);
      map.put("error_msg", errorMsg);
      map.put("latest", latest);
      map.put("check_amount", checkAmount);
      map.put("ec_channel", ecChannel);
      map.put("bussiness_unit_name", bussinessUnitName);
      map.put("company_name", companyName);
      map.put("company_tax_no", companyTaxNo);
      map.put("acq_date", acqDate);
      map.put("shop_id", shopId);
      map.put("oms_shop_id", omsShopId);
      map.put("refund_no", refundNo);
      map.put("post_no", postNo);
      map.put("post_way", postWay);
      map.put("return_reason", returnReason);
      map.put("status", status);
      map.put("rel_trade_no", relTradeNo);
      map.put("customer_name", customerName);
      map.put("total_qty", totalQty);
      map.put("rel_order_no", relOrderNo);
      map.put("gmt_create", BocpGenUtils.toTimestamp(gmtCreate));
      map.put("gmt_modified", BocpGenUtils.toTimestamp(gmtModified));

      return map;
  }

  public static OmsAfterSale fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    OmsAfterSale entity = new OmsAfterSale();
    if(map.containsKey("oms_id")) {
      Object obj = map.get("oms_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOmsId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOmsId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOmsId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("trade_no")) {
      Object obj = map.get("trade_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_status")) {
      Object obj = map.get("trade_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("nick_name")) {
      Object obj = map.get("nick_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNickName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oms_create_time")) {
      Object obj = map.get("oms_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOmsCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setOmsCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOmsCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOmsCreateTime(null);
      }
    }
    if(map.containsKey("oms_update_time")) {
      Object obj = map.get("oms_update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOmsUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setOmsUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOmsUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOmsUpdateTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDealStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("check_amount")) {
      Object obj = map.get("check_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCheckAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCheckAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCheckAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCheckAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ec_channel")) {
      Object obj = map.get("ec_channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEcChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bussiness_unit_name")) {
      Object obj = map.get("bussiness_unit_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBussinessUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("acq_date")) {
      Object obj = map.get("acq_date");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAcqDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oms_shop_id")) {
      Object obj = map.get("oms_shop_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOmsShopId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_no")) {
      Object obj = map.get("refund_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("post_no")) {
      Object obj = map.get("post_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPostNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("post_way")) {
      Object obj = map.get("post_way");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPostWay((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("return_reason")) {
      Object obj = map.get("return_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rel_trade_no")) {
      Object obj = map.get("rel_trade_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRelTradeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_name")) {
      Object obj = map.get("customer_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("total_qty")) {
      Object obj = map.get("total_qty");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTotalQty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rel_order_no")) {
      Object obj = map.get("rel_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRelOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtModified(null);
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("oms_id")) {
      Object obj = map.get("oms_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOmsId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOmsId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOmsId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("trade_no")) {
      Object obj = map.get("trade_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTradeNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("trade_status")) {
      Object obj = map.get("trade_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTradeStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("nick_name")) {
      Object obj = map.get("nick_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNickName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("oms_create_time")) {
      Object obj = map.get("oms_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOmsCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setOmsCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOmsCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setOmsCreateTime(null);
      }
    }
    if(map.containsKey("oms_update_time")) {
      Object obj = map.get("oms_update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOmsUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setOmsUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOmsUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setOmsUpdateTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDealStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataMD5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorMsg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLatest(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("check_amount")) {
      Object obj = map.get("check_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCheckAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCheckAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCheckAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCheckAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCheckAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("ec_channel")) {
      Object obj = map.get("ec_channel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEcChannel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bussiness_unit_name")) {
      Object obj = map.get("bussiness_unit_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBussinessUnitName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("acq_date")) {
      Object obj = map.get("acq_date");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAcqDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("oms_shop_id")) {
      Object obj = map.get("oms_shop_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOmsShopId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refund_no")) {
      Object obj = map.get("refund_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefundNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("post_no")) {
      Object obj = map.get("post_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPostNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("post_way")) {
      Object obj = map.get("post_way");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPostWay((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("return_reason")) {
      Object obj = map.get("return_reason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rel_trade_no")) {
      Object obj = map.get("rel_trade_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRelTradeNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customer_name")) {
      Object obj = map.get("customer_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("total_qty")) {
      Object obj = map.get("total_qty");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTotalQty((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rel_order_no")) {
      Object obj = map.get("rel_order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRelOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGmtModified(null);
      }
    }
  }
}
