package com.xforceplus.ultraman.app.policymanagement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 收款单应收单核销关系
 * </p>
 *
 * @author ultraman
 * @since 2025-02-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ReceiveCollectionWriteOffRelation implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 收款单ID
   */
  private Long skdId;

  /**
   * 应收单id
   */
  private Long receiveId;

  /**
   * 核销金额
   */
  private BigDecimal writeOffAmount;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 收款单编号
   */
  private String collectionOrderId;

  /**
   * 收款汇总单编号
   */
  private String sumCollectionOrderId;

  /**
   * 收款汇总单ID
   */
  private Long sumCollectionId;

  /**
   * 应收汇总单ID
   */
  private Long receiveSummaryId;

  /**
   * 应收汇总单编号
   */
  private String receiveSummaryNo;

  /**
   * 应收单编号
   */
  private String receiveNo;

  /**
   * 流转处理状态
   */
  private String dealStatus;

  /**
   * 作废状态
   */
  private String cancelStatus;


  /**
   * 对一关联关系 关联对象 receiveCollectionWriteOffSummary
   */
    private Long summaryId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("skd_id", skdId);
      map.put("receive_id", receiveId);
      map.put("write_off_amount", writeOffAmount);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("collection_order_id", collectionOrderId);
      map.put("sum_collection_order_id", sumCollectionOrderId);
      map.put("sum_collection_id", sumCollectionId);
      map.put("receive_summary_id", receiveSummaryId);
      map.put("receive_summary_no", receiveSummaryNo);
      map.put("receive_no", receiveNo);
      map.put("deal_status", dealStatus);
      map.put("cancel_status", cancelStatus);

       map.put("summary.id", summaryId);
      return map;
  }

  public static ReceiveCollectionWriteOffRelation fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ReceiveCollectionWriteOffRelation entity = new ReceiveCollectionWriteOffRelation();
    if(map.containsKey("skd_id")) {
      Object obj = map.get("skd_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSkdId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSkdId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSkdId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("receive_id")) {
      Object obj = map.get("receive_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceiveId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceiveId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceiveId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("write_off_amount")) {
      Object obj = map.get("write_off_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setWriteOffAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setWriteOffAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setWriteOffAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setWriteOffAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setWriteOffAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collection_order_id")) {
      Object obj = map.get("collection_order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sum_collection_order_id")) {
      Object obj = map.get("sum_collection_order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSumCollectionOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sum_collection_id")) {
      Object obj = map.get("sum_collection_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSumCollectionId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSumCollectionId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSumCollectionId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("receive_summary_id")) {
      Object obj = map.get("receive_summary_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceiveSummaryId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceiveSummaryId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceiveSummaryId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("receive_summary_no")) {
      Object obj = map.get("receive_summary_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveSummaryNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receive_no")) {
      Object obj = map.get("receive_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDealStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cancel_status")) {
      Object obj = map.get("cancel_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCancelStatus((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("summary.id")) {
        Object obj = map.get("summary.id");
      if(obj instanceof Long) {
        entity.setSummaryId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setSummaryId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("skd_id")) {
      Object obj = map.get("skd_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSkdId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSkdId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSkdId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("receive_id")) {
      Object obj = map.get("receive_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setReceiveId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReceiveId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setReceiveId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("write_off_amount")) {
      Object obj = map.get("write_off_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setWriteOffAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setWriteOffAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setWriteOffAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setWriteOffAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setWriteOffAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collection_order_id")) {
      Object obj = map.get("collection_order_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCollectionOrderId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sum_collection_order_id")) {
      Object obj = map.get("sum_collection_order_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSumCollectionOrderId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sum_collection_id")) {
      Object obj = map.get("sum_collection_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSumCollectionId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSumCollectionId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSumCollectionId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("receive_summary_id")) {
      Object obj = map.get("receive_summary_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setReceiveSummaryId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReceiveSummaryId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setReceiveSummaryId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("receive_summary_no")) {
      Object obj = map.get("receive_summary_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiveSummaryNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receive_no")) {
      Object obj = map.get("receive_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiveNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDealStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cancel_status")) {
      Object obj = map.get("cancel_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCancelStatus((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("summary.id")) {
        Object obj = map.get("summary.id");
        if(obj instanceof Long) {
          this.setSummaryId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSummaryId(Long.parseLong((String)obj));
        }
      }
  }
}
