package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * check_status
 * </p>
 *
 * @author ultraman
 * @since 2024-10-24
 */
public enum CheckStatus {

    _1("1", "已处理待对账"),
    _2("2", "待处理"),
    _4("4", "已对账待确认"),
    _5("5", "已确认待生成"),
    _6("6", "已生成待回传"),
    _7("7", "已回传");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CheckStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CheckStatus fromCode(String code) {
        return Stream.of(CheckStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
