package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ec_channel
 * </p>
 *
 * @author ultraman
 * @since 2024-10-24
 */
public enum EcChannel {

    _1("1", "天猫"),
    _2("2", "京东"),
    _3("3", "拼多多"),
    _4("4", "抖音"),
    _5("5", "快手");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    EcChannel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EcChannel fromCode(String code) {
        return Stream.of(EcChannel.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
