package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * failed_continue
 * </p>
 *
 * @author ultraman
 * @since 2024-10-24
 */
public enum FailedContinue {

    _1("1", "继续"),
    _0("0", "终止");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    FailedContinue(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FailedContinue fromCode(String code) {
        return Stream.of(FailedContinue.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
