package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * jky_pay_status
 * </p>
 *
 * @author ultraman
 * @since 2024-10-24
 */
public enum JkyPayStatus {

    _0("0", "未付款"),
    _5("5", "部分付款"),
    _9("9", "已付款");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    JkyPayStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static JkyPayStatus fromCode(String code) {
        return Stream.of(JkyPayStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
