package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * jky_pay_type
 * </p>
 *
 * @author ultraman
 * @since 2024-10-24
 */
public enum JkyPayType {

    _1("1", "支付宝"),
    _2("2", "财付通"),
    _3("3", "微信支付"),
    _4("4", "银联支付"),
    _5("5", "盛付通"),
    _6("6", "其他"),
    _7("7", "现金"),
    _8("8", "储值卡"),
    _9("9", "扫码付"),
    _10("10", "挂账"),
    _11("11", "诺诺支付"),
    _16("16", "易付宝"),
    _27("27", "通联支付"),
    _32("32", "有赞支付"),
    _33("33", "汇付支付"),
    _35("35", "易宝支付"),
    _37("37", "汇聚支付"),
    _38("38", "合利宝支付");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    JkyPayType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static JkyPayType fromCode(String code) {
        return Stream.of(JkyPayType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
