package com.xforceplus.ultraman.app.policymanagement.metadata.validator;

import com.xforceplus.ultraman.app.policymanagement.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.policymanagement.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-10-24
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgType.class)) {
            isValid = null != OrgType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrgType.class.getSimpleName());
            }
        }
        if(clazz.equals(CreationMethod.class)) {
            isValid = null != CreationMethod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CreationMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgStatus.class)) {
            isValid = null != OrgStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrgStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReadStatus.class)) {
            isValid = null != ReadStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReadStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CreateType.class)) {
            isValid = null != CreateType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CreateType.class.getSimpleName());
            }
        }
        if(clazz.equals(MessageType.class)) {
            isValid = null != MessageType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MessageType.class.getSimpleName());
            }
        }
        if(clazz.equals(EnableStatus.class)) {
            isValid = null != EnableStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EnableStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VariableType.class)) {
            isValid = null != VariableType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, VariableType.class.getSimpleName());
            }
        }
        if(clazz.equals(WorkflowStatus.class)) {
            isValid = null != WorkflowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, WorkflowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PluginCode.class)) {
            isValid = null != PluginCode.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PluginCode.class.getSimpleName());
            }
        }
        if(clazz.equals(DataType.class)) {
            isValid = null != DataType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DataType.class.getSimpleName());
            }
        }
        if(clazz.equals(DataSource.class)) {
            isValid = null != DataSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DataSource.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchType.class)) {
            isValid = null != MatchType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MatchType.class.getSimpleName());
            }
        }
        if(clazz.equals(HandleType.class)) {
            isValid = null != HandleType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, HandleType.class.getSimpleName());
            }
        }
        if(clazz.equals(ResultType.class)) {
            isValid = null != ResultType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ResultType.class.getSimpleName());
            }
        }
        if(clazz.equals(FailedContinue.class)) {
            isValid = null != FailedContinue.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FailedContinue.class.getSimpleName());
            }
        }
        if(clazz.equals(TbSalesOrderStatus.class)) {
            isValid = null != TbSalesOrderStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TbSalesOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddAfterSalesStatus.class)) {
            isValid = null != PddAfterSalesStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddAfterSalesStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddConfirmStatus.class)) {
            isValid = null != PddConfirmStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddConfirmStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddGroupRole.class)) {
            isValid = null != PddGroupRole.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddGroupRole.class.getSimpleName());
            }
        }
        if(clazz.equals(PddGroupStatus.class)) {
            isValid = null != PddGroupStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddGroupStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddHomeDeliveryType.class)) {
            isValid = null != PddHomeDeliveryType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddHomeDeliveryType.class.getSimpleName());
            }
        }
        if(clazz.equals(PddIsLuckyFlag.class)) {
            isValid = null != PddIsLuckyFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddIsLuckyFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(PddKktBizType.class)) {
            isValid = null != PddKktBizType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddKktBizType.class.getSimpleName());
            }
        }
        if(clazz.equals(PddOrderStatus.class)) {
            isValid = null != PddOrderStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddPayType.class)) {
            isValid = null != PddPayType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddPayType.class.getSimpleName());
            }
        }
        if(clazz.equals(PddOrderControlStatus.class)) {
            isValid = null != PddOrderControlStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddOrderControlStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddShippingType.class)) {
            isValid = null != PddShippingType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddShippingType.class.getSimpleName());
            }
        }
        if(clazz.equals(PddStockOutHandleStatus.class)) {
            isValid = null != PddStockOutHandleStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddStockOutHandleStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddTradeType.class)) {
            isValid = null != PddTradeType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddTradeType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyOrderTypes.class)) {
            isValid = null != DyOrderTypes.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DyOrderTypes.class.getSimpleName());
            }
        }
        if(clazz.equals(DyOrderStatys.class)) {
            isValid = null != DyOrderStatys.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DyOrderStatys.class.getSimpleName());
            }
        }
        if(clazz.equals(DyPayType.class)) {
            isValid = null != DyPayType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DyPayType.class.getSimpleName());
            }
        }
        if(clazz.equals(KsOrderStatus.class)) {
            isValid = null != KsOrderStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, KsOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(KsCpsType.class)) {
            isValid = null != KsCpsType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, KsCpsType.class.getSimpleName());
            }
        }
        if(clazz.equals(KsCoType.class)) {
            isValid = null != KsCoType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, KsCoType.class.getSimpleName());
            }
        }
        if(clazz.equals(KsPayType.class)) {
            isValid = null != KsPayType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, KsPayType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyTradeType.class)) {
            isValid = null != DyTradeType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DyTradeType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyGoodsType.class)) {
            isValid = null != DyGoodsType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DyGoodsType.class.getSimpleName());
            }
        }
        if(clazz.equals(OmsTradeStatus.class)) {
            isValid = null != OmsTradeStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OmsTradeStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceivableOrderType.class)) {
            isValid = null != ReceivableOrderType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReceivableOrderType.class.getSimpleName());
            }
        }
        if(clazz.equals(EcChannel.class)) {
            isValid = null != EcChannel.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EcChannel.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckStatus.class)) {
            isValid = null != CheckStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CheckStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillChangeRecordSource.class)) {
            isValid = null != BillChangeRecordSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillChangeRecordSource.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceivableOrderStatus.class)) {
            isValid = null != ReceivableOrderStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReceivableOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyPayType.class)) {
            isValid = null != JkyPayType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, JkyPayType.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyTradeFrom.class)) {
            isValid = null != JkyTradeFrom.fromCode(value);
            if(!isValid) {
                unValidMsg(context, JkyTradeFrom.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyPayStatus.class)) {
            isValid = null != JkyPayStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, JkyPayStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyTradeStatus.class)) {
            isValid = null != JkyTradeStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, JkyTradeStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyInvoiceType.class)) {
            isValid = null != JkyInvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, JkyInvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyIsBillCheck.class)) {
            isValid = null != JkyIsBillCheck.fromCode(value);
            if(!isValid) {
                unValidMsg(context, JkyIsBillCheck.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyLogisticType.class)) {
            isValid = null != JkyLogisticType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, JkyLogisticType.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
