package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * bill_change_record_source
 * </p>
 *
 * @author ultraman
 * @since 2024-10-25
 */
public enum BillChangeRecordSource {

    _10("10", "天猫订单"),
    _20("20", "京东订单"),
    _30("30", "拼多多订单"),
    _40("40", "抖音订单"),
    _50("50", "快手订单"),
    _60("60", "OMS订单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillChangeRecordSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillChangeRecordSource fromCode(String code) {
        return Stream.of(BillChangeRecordSource.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
