package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * data_source
 * </p>
 *
 * @author ultraman
 * @since 2024-10-25
 */
public enum DataSource {

    AAA("aaa", "系统来源1"),
    BBB("bbb", "系统来源2");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DataSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DataSource fromCode(String code) {
        return Stream.of(DataSource.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
