package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ks_pay_type
 * </p>
 *
 * @author ultraman
 * @since 2024-10-25
 */
public enum KsPayType {

    _0("0", "未知"),
    _1("1", "微信"),
    _2("2", "支付宝"),
    _3("3", "平安"),
    _99("99", "银行转账"),
    _88("88", "支付宝先用后付");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    KsPayType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static KsPayType fromCode(String code) {
        return Stream.of(KsPayType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
