package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pdd_shipping_type
 * </p>
 *
 * @author ultraman
 * @since 2024-10-25
 */
public enum PddShippingType {

    _1("1", "预约配送"),
    _2("2", "1小时达"),
    _3("3", "消费者预约送达"),
    _0("0", " ");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PddShippingType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PddShippingType fromCode(String code) {
        return Stream.of(PddShippingType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
