package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pdd_trade_type
 * </p>
 *
 * @author ultraman
 * @since 2024-10-25
 */
public enum PddTradeType {

    _0("0", "普通订单"),
    _1("1", "定金订单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PddTradeType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PddTradeType fromCode(String code) {
        return Stream.of(PddTradeType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
