package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * plugin_code
 * </p>
 *
 * @author ultraman
 * @since 2024-10-25
 */
public enum PluginCode {

    BUSINESS_NO("business_no", "businessNo"),
    MAIN_TAG("main_tag", "mainTag"),
    SINK_JANUS("sink_janus", "sinkJanus");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PluginCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PluginCode fromCode(String code) {
        return Stream.of(PluginCode.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
