package com.xforceplus.ultraman.app.policymanagement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * jky_oms_order_detail
 * </p>
 *
 * @author ultraman
 * @since 2024-10-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class JkyOmsOrderDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 明细ID
   */
  private Long jkyId;
  /**
   * 销售单id
   */
  private Long tradeId;
  /**
   * 货品编号
   */
  private String goodsNo;
  /**
   * 货品名称
   */
  private String goodsName;
  /**
   * 规格名称
   */
  private String specName;
  /**
   * 条码
   */
  private String barcode;
  /**
   * 数量
   */
  private BigDecimal sellCount;
  /**
   * 单位
   */
  private String unit;
  /**
   * 单价
   */
  private BigDecimal sellPrice;
  /**
   * 总金额
   */
  private BigDecimal sellTotal;
  /**
   * 货品成本
   */
  private BigDecimal cost;
  /**
   * 优惠金额
   */
  private BigDecimal discountTotal;
  /**
   * 抵扣积分
   */
  private Long discountPoint;
  /**
   * 税额
   */
  private BigDecimal taxFee;
  /**
   * 分摊金额
   */
  private BigDecimal shareFavourableFee;
  /**
   * 预估重量
   */
  private BigDecimal estimateWeight;
  /**
   * 货品备注
   */
  private String goodsMemo;
  /**
   * 货品类别
   */
  private String cateName;
  /**
   * 品牌
   */
  private String brandName;
  /**
   * 货品标签
   */
  private String goodsTags;
  /**
   * 组合装标记
   */
  private Long isFit;
  /**
   * 赠品标记
   */
  private Boolean isGift;
  /**
   * 优惠
   */
  private BigDecimal discountFee;
  /**
   * 税率
   */
  private BigDecimal taxRate;
  /**
   * 预估体积
   */
  private BigDecimal estimateGoodsVolume;
  /**
   * 是否预售货品标记
   */
  private Boolean isPresell;
  /**
   * 终端销售单价
   */
  private BigDecimal customerPrice;
  /**
   * 终端销售金额
   */
  private BigDecimal customerTotal;
  /**
   * 交易编号
   */
  private String tradeGoodsNo;
  /**
   * 交易名称
   */
  private String tradeGoodsName;
  /**
   * 交易规格
   */
  private String tradeGoodsSpec;
  /**
   * 交易单位
   */
  private String tradeGoodsUnit;
  /**
   * 网店子订单号
   */
  private String sourceSubtradeNo;
  /**
   * 平台代码
   */
  private String platCode;
  /**
   * 平台商品id
   */
  private String platGoodsId;
  /**
   * 商品明细id
   */
  private String subTradeId;
  /**
   * 平台主播id
   */
  private String platAuthorId;
  /**
   * 平台主播名称
   */
  private String platAuthorName;
  /**
   * 平台赠品标记
   */
  private String isPlatGift;
  /**
   * 货品平台优惠
   */
  private BigDecimal goodsPlatDiscountFee;
  /**
   * 货品平台优惠明细-优惠金额
   */
  private BigDecimal platDiscountDetailDiscountFee;
  /**
   * 货品平台优惠明细-优惠金额名称
   */
  private BigDecimal platDiscountDetailDiscountName;
  /**
   * 分摊后金额
   */
  private BigDecimal shareFavourableAfterFee;
  /**
   * 实付金额
   */
  private BigDecimal divideSellTotal;
  /**
   * 订单商品优惠分摊
   */
  private BigDecimal shareOrderDiscountFee;
  /**
   * 订单平台优惠分摊
   */
  private BigDecimal shareOrderPlatDiscountFee;
  /**
   * 网店主订单号
   */
  private String sourceTradeNo;
  /**
   * 实发数
   */
  private BigDecimal actualSendCount;
  /**
   * 平台商品链接skuId
   */
  private String platSkuId;
  /**
   * 终端网店订单号
   */
  private String customerTradeNo;
  /**
   * 终端网店子订单号
   */
  private String customerSubtradeNo;
  /**
   * 平台定制信息
   */
  private String platcustomdata;
  /**
   * 考核成本
   */
  private BigDecimal assessmentCostLocal;
  /**
   * 考核毛利
   */
  private BigDecimal assessmentGrossProfitLocal;
  /**
   * 考核毛利率
   */
  private String assessmentGrossProfitPercent;
  /**
   * 货品级流量题材
   */
  private String goodsCompassSourceContentType;
  /**
   * 货品业务员
   */
  private String goodsSeller;
  /**
   * 入库创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtCreate;
  /**
   * 更新时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtModified;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;

  /**
   * 对一关联关系 关联对象 jkyOmsOrder
   */
  private Long jkyOmsOrderDetailId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("jky_id", jkyId);
      map.put("trade_id", tradeId);
      map.put("goods_no", goodsNo);
      map.put("goods_name", goodsName);
      map.put("spec_name", specName);
      map.put("barcode", barcode);
      map.put("sell_count", sellCount);
      map.put("unit", unit);
      map.put("sell_price", sellPrice);
      map.put("sell_total", sellTotal);
      map.put("cost", cost);
      map.put("discount_total", discountTotal);
      map.put("discount_point", discountPoint);
      map.put("tax_fee", taxFee);
      map.put("share_favourable_fee", shareFavourableFee);
      map.put("estimate_weight", estimateWeight);
      map.put("goods_memo", goodsMemo);
      map.put("cate_name", cateName);
      map.put("brand_name", brandName);
      map.put("goods_tags", goodsTags);
      map.put("is_fit", isFit);
      map.put("is_gift", isGift);
      map.put("discount_fee", discountFee);
      map.put("tax_rate", taxRate);
      map.put("estimate_goods_volume", estimateGoodsVolume);
      map.put("is_presell", isPresell);
      map.put("customer_price", customerPrice);
      map.put("customer_total", customerTotal);
      map.put("trade_goods_no", tradeGoodsNo);
      map.put("trade_goods_name", tradeGoodsName);
      map.put("trade_goods_spec", tradeGoodsSpec);
      map.put("trade_goods_unit", tradeGoodsUnit);
      map.put("source_subtrade_no", sourceSubtradeNo);
      map.put("plat_code", platCode);
      map.put("plat_goods_id", platGoodsId);
      map.put("sub_trade_id", subTradeId);
      map.put("plat_author_id", platAuthorId);
      map.put("plat_author_name", platAuthorName);
      map.put("is_plat_gift", isPlatGift);
      map.put("goods_plat_discount_fee", goodsPlatDiscountFee);
      map.put("plat_discount_detail_discount_fee", platDiscountDetailDiscountFee);
      map.put("plat_discount_detail_discount_name", platDiscountDetailDiscountName);
      map.put("share_favourable_after_fee", shareFavourableAfterFee);
      map.put("divide_sell_total", divideSellTotal);
      map.put("share_order_discount_fee", shareOrderDiscountFee);
      map.put("share_order_plat_discount_fee", shareOrderPlatDiscountFee);
      map.put("source_trade_no", sourceTradeNo);
      map.put("actual_send_count", actualSendCount);
      map.put("plat_sku_id", platSkuId);
      map.put("customer_trade_no", customerTradeNo);
      map.put("customer_subtrade_no", customerSubtradeNo);
      map.put("platcustomdata", platcustomdata);
      map.put("assessment_cost_local", assessmentCostLocal);
      map.put("assessment_gross_profit_local", assessmentGrossProfitLocal);
      map.put("assessment_gross_profit_percent", assessmentGrossProfitPercent);
      map.put("goods_compass_source_content_type", goodsCompassSourceContentType);
      map.put("goods_seller", goodsSeller);
      map.put("gmt_create", BocpGenUtils.toTimestamp(gmtCreate));
      map.put("gmt_modified", BocpGenUtils.toTimestamp(gmtModified));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      map.put("jkyOmsOrderDetail.id", jkyOmsOrderDetailId);
      return map;
  }

  public static JkyOmsOrderDetail fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    JkyOmsOrderDetail entity = new JkyOmsOrderDetail();

    if(map.containsKey("jky_id")) {
      Object obj = map.get("jky_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setJkyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJkyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setJkyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("trade_id")) {
      Object obj = map.get("trade_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTradeId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTradeId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTradeId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("goods_no")) {
      Object obj = map.get("goods_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_name")) {
      Object obj = map.get("goods_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("spec_name")) {
      Object obj = map.get("spec_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sell_count")) {
      Object obj = map.get("sell_count");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSellCount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSellCount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSellCount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellCount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellCount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sell_price")) {
      Object obj = map.get("sell_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSellPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSellPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSellPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sell_total")) {
      Object obj = map.get("sell_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSellTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSellTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSellTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("cost")) {
      Object obj = map.get("cost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discount_total")) {
      Object obj = map.get("discount_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discount_point")) {
      Object obj = map.get("discount_point");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDiscountPoint((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountPoint(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setDiscountPoint(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tax_fee")) {
      Object obj = map.get("tax_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("share_favourable_fee")) {
      Object obj = map.get("share_favourable_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setShareFavourableFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setShareFavourableFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setShareFavourableFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setShareFavourableFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setShareFavourableFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("estimate_weight")) {
      Object obj = map.get("estimate_weight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setEstimateWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setEstimateWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setEstimateWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEstimateWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setEstimateWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("goods_memo")) {
      Object obj = map.get("goods_memo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsMemo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cate_name")) {
      Object obj = map.get("cate_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCateName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brand_name")) {
      Object obj = map.get("brand_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBrandName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_tags")) {
      Object obj = map.get("goods_tags");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsTags((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_fit")) {
      Object obj = map.get("is_fit");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setIsFit((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsFit(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setIsFit(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("is_gift")) {
      Object obj = map.get("is_gift");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsGift((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsGift(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("discount_fee")) {
      Object obj = map.get("discount_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("estimate_goods_volume")) {
      Object obj = map.get("estimate_goods_volume");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setEstimateGoodsVolume((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setEstimateGoodsVolume(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setEstimateGoodsVolume(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEstimateGoodsVolume(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setEstimateGoodsVolume(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("is_presell")) {
      Object obj = map.get("is_presell");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsPresell((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsPresell(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("customer_price")) {
      Object obj = map.get("customer_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCustomerPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCustomerPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCustomerPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCustomerPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCustomerPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("customer_total")) {
      Object obj = map.get("customer_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCustomerTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCustomerTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCustomerTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCustomerTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCustomerTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("trade_goods_no")) {
      Object obj = map.get("trade_goods_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeGoodsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_goods_name")) {
      Object obj = map.get("trade_goods_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeGoodsName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_goods_spec")) {
      Object obj = map.get("trade_goods_spec");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeGoodsSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_goods_unit")) {
      Object obj = map.get("trade_goods_unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeGoodsUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source_subtrade_no")) {
      Object obj = map.get("source_subtrade_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSourceSubtradeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("plat_code")) {
      Object obj = map.get("plat_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlatCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("plat_goods_id")) {
      Object obj = map.get("plat_goods_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlatGoodsId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sub_trade_id")) {
      Object obj = map.get("sub_trade_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubTradeId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("plat_author_id")) {
      Object obj = map.get("plat_author_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlatAuthorId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("plat_author_name")) {
      Object obj = map.get("plat_author_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlatAuthorName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_plat_gift")) {
      Object obj = map.get("is_plat_gift");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsPlatGift((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_plat_discount_fee")) {
      Object obj = map.get("goods_plat_discount_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGoodsPlatDiscountFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGoodsPlatDiscountFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGoodsPlatDiscountFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGoodsPlatDiscountFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGoodsPlatDiscountFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("plat_discount_detail_discount_fee")) {
      Object obj = map.get("plat_discount_detail_discount_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPlatDiscountDetailDiscountFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPlatDiscountDetailDiscountFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPlatDiscountDetailDiscountFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPlatDiscountDetailDiscountFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPlatDiscountDetailDiscountFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("plat_discount_detail_discount_name")) {
      Object obj = map.get("plat_discount_detail_discount_name");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPlatDiscountDetailDiscountName((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPlatDiscountDetailDiscountName(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPlatDiscountDetailDiscountName(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPlatDiscountDetailDiscountName(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPlatDiscountDetailDiscountName(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("share_favourable_after_fee")) {
      Object obj = map.get("share_favourable_after_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setShareFavourableAfterFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setShareFavourableAfterFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setShareFavourableAfterFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setShareFavourableAfterFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setShareFavourableAfterFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("divide_sell_total")) {
      Object obj = map.get("divide_sell_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDivideSellTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDivideSellTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDivideSellTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDivideSellTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDivideSellTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("share_order_discount_fee")) {
      Object obj = map.get("share_order_discount_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setShareOrderDiscountFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setShareOrderDiscountFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setShareOrderDiscountFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setShareOrderDiscountFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setShareOrderDiscountFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("share_order_plat_discount_fee")) {
      Object obj = map.get("share_order_plat_discount_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setShareOrderPlatDiscountFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setShareOrderPlatDiscountFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setShareOrderPlatDiscountFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setShareOrderPlatDiscountFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setShareOrderPlatDiscountFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("source_trade_no")) {
      Object obj = map.get("source_trade_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSourceTradeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("actual_send_count")) {
      Object obj = map.get("actual_send_count");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setActualSendCount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setActualSendCount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setActualSendCount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setActualSendCount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setActualSendCount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("plat_sku_id")) {
      Object obj = map.get("plat_sku_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlatSkuId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_trade_no")) {
      Object obj = map.get("customer_trade_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerTradeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_subtrade_no")) {
      Object obj = map.get("customer_subtrade_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerSubtradeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("platcustomdata")) {
      Object obj = map.get("platcustomdata");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlatcustomdata((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("assessment_cost_local")) {
      Object obj = map.get("assessment_cost_local");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAssessmentCostLocal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAssessmentCostLocal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAssessmentCostLocal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAssessmentCostLocal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAssessmentCostLocal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("assessment_gross_profit_local")) {
      Object obj = map.get("assessment_gross_profit_local");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAssessmentGrossProfitLocal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAssessmentGrossProfitLocal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAssessmentGrossProfitLocal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAssessmentGrossProfitLocal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAssessmentGrossProfitLocal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("assessment_gross_profit_percent")) {
      Object obj = map.get("assessment_gross_profit_percent");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAssessmentGrossProfitPercent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_compass_source_content_type")) {
      Object obj = map.get("goods_compass_source_content_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsCompassSourceContentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_seller")) {
      Object obj = map.get("goods_seller");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsSeller((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("jkyOmsOrderDetail.id")) {
       Object obj = map.get("jkyOmsOrderDetail.id");
       if(obj instanceof Long) {
         entity.setJkyOmsOrderDetailId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setJkyOmsOrderDetailId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("jky_id")) {
      Object obj = map.get("jky_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setJkyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setJkyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setJkyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("trade_id")) {
      Object obj = map.get("trade_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTradeId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTradeId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTradeId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("goods_no")) {
      Object obj = map.get("goods_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGoodsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_name")) {
      Object obj = map.get("goods_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGoodsName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("spec_name")) {
      Object obj = map.get("spec_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSpecName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sell_count")) {
      Object obj = map.get("sell_count");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSellCount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSellCount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSellCount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSellCount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSellCount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sell_price")) {
      Object obj = map.get("sell_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSellPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSellPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSellPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSellPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSellPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sell_total")) {
      Object obj = map.get("sell_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSellTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSellTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSellTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSellTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSellTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("cost")) {
      Object obj = map.get("cost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discount_total")) {
      Object obj = map.get("discount_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDiscountTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDiscountTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDiscountTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDiscountTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDiscountTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discount_point")) {
      Object obj = map.get("discount_point");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDiscountPoint((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDiscountPoint(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setDiscountPoint(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tax_fee")) {
      Object obj = map.get("tax_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("share_favourable_fee")) {
      Object obj = map.get("share_favourable_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setShareFavourableFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setShareFavourableFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setShareFavourableFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setShareFavourableFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setShareFavourableFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("estimate_weight")) {
      Object obj = map.get("estimate_weight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setEstimateWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setEstimateWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setEstimateWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setEstimateWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setEstimateWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("goods_memo")) {
      Object obj = map.get("goods_memo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGoodsMemo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cate_name")) {
      Object obj = map.get("cate_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCateName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brand_name")) {
      Object obj = map.get("brand_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBrandName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_tags")) {
      Object obj = map.get("goods_tags");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGoodsTags((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_fit")) {
      Object obj = map.get("is_fit");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setIsFit((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setIsFit(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setIsFit(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("is_gift")) {
      Object obj = map.get("is_gift");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setIsGift((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setIsGift(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("discount_fee")) {
      Object obj = map.get("discount_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDiscountFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDiscountFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDiscountFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDiscountFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDiscountFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("estimate_goods_volume")) {
      Object obj = map.get("estimate_goods_volume");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setEstimateGoodsVolume((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setEstimateGoodsVolume(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setEstimateGoodsVolume(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setEstimateGoodsVolume(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setEstimateGoodsVolume(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("is_presell")) {
      Object obj = map.get("is_presell");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setIsPresell((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setIsPresell(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("customer_price")) {
      Object obj = map.get("customer_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setCustomerPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setCustomerPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setCustomerPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCustomerPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setCustomerPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("customer_total")) {
      Object obj = map.get("customer_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setCustomerTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setCustomerTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setCustomerTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCustomerTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setCustomerTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("trade_goods_no")) {
      Object obj = map.get("trade_goods_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTradeGoodsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_goods_name")) {
      Object obj = map.get("trade_goods_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTradeGoodsName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_goods_spec")) {
      Object obj = map.get("trade_goods_spec");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTradeGoodsSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_goods_unit")) {
      Object obj = map.get("trade_goods_unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTradeGoodsUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source_subtrade_no")) {
      Object obj = map.get("source_subtrade_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSourceSubtradeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("plat_code")) {
      Object obj = map.get("plat_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPlatCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("plat_goods_id")) {
      Object obj = map.get("plat_goods_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPlatGoodsId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sub_trade_id")) {
      Object obj = map.get("sub_trade_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSubTradeId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("plat_author_id")) {
      Object obj = map.get("plat_author_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPlatAuthorId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("plat_author_name")) {
      Object obj = map.get("plat_author_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPlatAuthorName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_plat_gift")) {
      Object obj = map.get("is_plat_gift");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsPlatGift((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_plat_discount_fee")) {
      Object obj = map.get("goods_plat_discount_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setGoodsPlatDiscountFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setGoodsPlatDiscountFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setGoodsPlatDiscountFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGoodsPlatDiscountFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setGoodsPlatDiscountFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("plat_discount_detail_discount_fee")) {
      Object obj = map.get("plat_discount_detail_discount_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPlatDiscountDetailDiscountFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPlatDiscountDetailDiscountFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPlatDiscountDetailDiscountFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPlatDiscountDetailDiscountFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPlatDiscountDetailDiscountFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("plat_discount_detail_discount_name")) {
      Object obj = map.get("plat_discount_detail_discount_name");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPlatDiscountDetailDiscountName((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPlatDiscountDetailDiscountName(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPlatDiscountDetailDiscountName(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPlatDiscountDetailDiscountName(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPlatDiscountDetailDiscountName(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("share_favourable_after_fee")) {
      Object obj = map.get("share_favourable_after_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setShareFavourableAfterFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setShareFavourableAfterFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setShareFavourableAfterFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setShareFavourableAfterFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setShareFavourableAfterFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("divide_sell_total")) {
      Object obj = map.get("divide_sell_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDivideSellTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDivideSellTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDivideSellTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDivideSellTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDivideSellTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("share_order_discount_fee")) {
      Object obj = map.get("share_order_discount_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setShareOrderDiscountFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setShareOrderDiscountFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setShareOrderDiscountFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setShareOrderDiscountFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setShareOrderDiscountFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("share_order_plat_discount_fee")) {
      Object obj = map.get("share_order_plat_discount_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setShareOrderPlatDiscountFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setShareOrderPlatDiscountFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setShareOrderPlatDiscountFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setShareOrderPlatDiscountFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setShareOrderPlatDiscountFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("source_trade_no")) {
      Object obj = map.get("source_trade_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSourceTradeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("actual_send_count")) {
      Object obj = map.get("actual_send_count");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setActualSendCount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setActualSendCount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setActualSendCount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setActualSendCount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setActualSendCount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("plat_sku_id")) {
      Object obj = map.get("plat_sku_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPlatSkuId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_trade_no")) {
      Object obj = map.get("customer_trade_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustomerTradeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_subtrade_no")) {
      Object obj = map.get("customer_subtrade_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustomerSubtradeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("platcustomdata")) {
      Object obj = map.get("platcustomdata");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPlatcustomdata((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("assessment_cost_local")) {
      Object obj = map.get("assessment_cost_local");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAssessmentCostLocal((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAssessmentCostLocal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAssessmentCostLocal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAssessmentCostLocal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAssessmentCostLocal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("assessment_gross_profit_local")) {
      Object obj = map.get("assessment_gross_profit_local");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAssessmentGrossProfitLocal((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAssessmentGrossProfitLocal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAssessmentGrossProfitLocal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAssessmentGrossProfitLocal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAssessmentGrossProfitLocal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("assessment_gross_profit_percent")) {
      Object obj = map.get("assessment_gross_profit_percent");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAssessmentGrossProfitPercent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_compass_source_content_type")) {
      Object obj = map.get("goods_compass_source_content_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGoodsCompassSourceContentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_seller")) {
      Object obj = map.get("goods_seller");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGoodsSeller((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
  if(map.containsKey("jkyOmsOrderDetail.id")) {
    Object obj = map.get("jkyOmsOrderDetail.id");
    if(obj instanceof Long) {
        this.setJkyOmsOrderDetailId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setJkyOmsOrderDetailId(Long.parseLong((String)obj));
    }
  }
  }
}
