package com.xforceplus.ultraman.app.policymanagement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * ks_sales_order_detail
 * </p>
 *
 * @author ultraman
 * @since 2024-10-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class KsSalesOrderDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * id
   */
  private Long ksId;
  /**
   * 租户编码
   */
  private String ksTenantCode;
  /**
   * 店铺id
   */
  private String shopId;
  /**
   * 订单Id
   */
  private Long oid;
  /**
   * 快手商品skuid
   */
  private Long skuId;
  /**
   * 服务商商品skuid
   */
  private String relSkuId;
  /**
   * sku商品规格快照
   */
  private String skuDesc;
  /**
   * sku编码
   */
  private String skuNick;
  /**
   * 商品id
   */
  private Long itemId;
  /**
   * 服务商商品id
   */
  private Long relItemId;
  /**
   * 商品名称
   */
  private String itemTitle;
  /**
   * 商品链接
   */
  private String itemLinkUrl;
  /**
   * 商品图片地址
   */
  private String itemPicUrl;
  /**
   * sku数量
   */
  private Long num;
  /**
   * 商品促销前单价快照
   */
  private BigDecimal originalPrice;
  /**
   * 折扣金额
   */
  private BigDecimal discountFee;
  /**
   * 商品单价快照
   */
  private BigDecimal price;
  /**
   * sku修改之前原商品信息
   */
  private BigDecimal itemPrevInfo;
  /**
   * 外部货品编码
   */
  private String goodsCode;
  /**
   * 快手仓库编码
   */
  private String warehouseCode;
  /**
   * 订单商品id
   */
  private Long orderItemId;
  /**
   * 电子凭证券码库ID
   */
  private Long goodStoreCode;
  /**
   * 服务信息
   */
  private String serviceInfo;
  /**
   * 扩展信息
   */
  private String itemExtra;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtCreate;
  /**
   * 更新时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtModified;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;

  /**
   * 对一关联关系 关联对象 ksSalesOrder
   */
  private Long ksSalesOrderAndDetailMapId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("ks_id", ksId);
      map.put("ks_tenant_code", ksTenantCode);
      map.put("shop_id", shopId);
      map.put("oid", oid);
      map.put("sku_id", skuId);
      map.put("rel_sku_id", relSkuId);
      map.put("sku_desc", skuDesc);
      map.put("sku_nick", skuNick);
      map.put("item_id", itemId);
      map.put("rel_item_id", relItemId);
      map.put("item_title", itemTitle);
      map.put("item_link_url", itemLinkUrl);
      map.put("item_pic_url", itemPicUrl);
      map.put("num", num);
      map.put("original_price", originalPrice);
      map.put("discount_fee", discountFee);
      map.put("price", price);
      map.put("item_prev_info", itemPrevInfo);
      map.put("goods_code", goodsCode);
      map.put("warehouse_code", warehouseCode);
      map.put("order_item_id", orderItemId);
      map.put("good_store_code", goodStoreCode);
      map.put("service_info", serviceInfo);
      map.put("item_extra", itemExtra);
      map.put("gmt_create", BocpGenUtils.toTimestamp(gmtCreate));
      map.put("gmt_modified", BocpGenUtils.toTimestamp(gmtModified));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      map.put("ksSalesOrderAndDetailMap.id", ksSalesOrderAndDetailMapId);
      return map;
  }

  public static KsSalesOrderDetail fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    KsSalesOrderDetail entity = new KsSalesOrderDetail();

    if(map.containsKey("ks_id")) {
      Object obj = map.get("ks_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setKsId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setKsId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setKsId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ks_tenant_code")) {
      Object obj = map.get("ks_tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKsTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oid")) {
      Object obj = map.get("oid");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOid((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOid(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOid(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sku_id")) {
      Object obj = map.get("sku_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSkuId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSkuId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSkuId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("rel_sku_id")) {
      Object obj = map.get("rel_sku_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRelSkuId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sku_desc")) {
      Object obj = map.get("sku_desc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSkuDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sku_nick")) {
      Object obj = map.get("sku_nick");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSkuNick((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_id")) {
      Object obj = map.get("item_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setItemId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setItemId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setItemId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("rel_item_id")) {
      Object obj = map.get("rel_item_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRelItemId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRelItemId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setRelItemId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("item_title")) {
      Object obj = map.get("item_title");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_link_url")) {
      Object obj = map.get("item_link_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemLinkUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_pic_url")) {
      Object obj = map.get("item_pic_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemPicUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("num")) {
      Object obj = map.get("num");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("original_price")) {
      Object obj = map.get("original_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOriginalPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOriginalPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOriginalPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOriginalPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOriginalPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discount_fee")) {
      Object obj = map.get("discount_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("price")) {
      Object obj = map.get("price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("item_prev_info")) {
      Object obj = map.get("item_prev_info");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setItemPrevInfo((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setItemPrevInfo(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setItemPrevInfo(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setItemPrevInfo(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setItemPrevInfo(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("goods_code")) {
      Object obj = map.get("goods_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warehouse_code")) {
      Object obj = map.get("warehouse_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWarehouseCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_item_id")) {
      Object obj = map.get("order_item_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderItemId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderItemId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrderItemId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("good_store_code")) {
      Object obj = map.get("good_store_code");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGoodStoreCode((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGoodStoreCode(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setGoodStoreCode(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("service_info")) {
      Object obj = map.get("service_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setServiceInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_extra")) {
      Object obj = map.get("item_extra");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemExtra((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("ksSalesOrderAndDetailMap.id")) {
       Object obj = map.get("ksSalesOrderAndDetailMap.id");
       if(obj instanceof Long) {
         entity.setKsSalesOrderAndDetailMapId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setKsSalesOrderAndDetailMapId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("ks_id")) {
      Object obj = map.get("ks_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setKsId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setKsId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setKsId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ks_tenant_code")) {
      Object obj = map.get("ks_tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setKsTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setShopId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oid")) {
      Object obj = map.get("oid");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOid((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOid(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setOid(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sku_id")) {
      Object obj = map.get("sku_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSkuId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSkuId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSkuId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("rel_sku_id")) {
      Object obj = map.get("rel_sku_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRelSkuId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sku_desc")) {
      Object obj = map.get("sku_desc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSkuDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sku_nick")) {
      Object obj = map.get("sku_nick");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSkuNick((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_id")) {
      Object obj = map.get("item_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setItemId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setItemId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setItemId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("rel_item_id")) {
      Object obj = map.get("rel_item_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRelItemId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRelItemId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setRelItemId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("item_title")) {
      Object obj = map.get("item_title");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setItemTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_link_url")) {
      Object obj = map.get("item_link_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setItemLinkUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_pic_url")) {
      Object obj = map.get("item_pic_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setItemPicUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("num")) {
      Object obj = map.get("num");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("original_price")) {
      Object obj = map.get("original_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setOriginalPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setOriginalPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setOriginalPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOriginalPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setOriginalPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discount_fee")) {
      Object obj = map.get("discount_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDiscountFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDiscountFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDiscountFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDiscountFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDiscountFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("price")) {
      Object obj = map.get("price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("item_prev_info")) {
      Object obj = map.get("item_prev_info");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setItemPrevInfo((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setItemPrevInfo(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setItemPrevInfo(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setItemPrevInfo(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setItemPrevInfo(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("goods_code")) {
      Object obj = map.get("goods_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGoodsCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warehouse_code")) {
      Object obj = map.get("warehouse_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setWarehouseCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_item_id")) {
      Object obj = map.get("order_item_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOrderItemId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOrderItemId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setOrderItemId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("good_store_code")) {
      Object obj = map.get("good_store_code");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGoodStoreCode((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGoodStoreCode(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setGoodStoreCode(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("service_info")) {
      Object obj = map.get("service_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setServiceInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_extra")) {
      Object obj = map.get("item_extra");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setItemExtra((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
  if(map.containsKey("ksSalesOrderAndDetailMap.id")) {
    Object obj = map.get("ksSalesOrderAndDetailMap.id");
    if(obj instanceof Long) {
        this.setKsSalesOrderAndDetailMapId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setKsSalesOrderAndDetailMapId(Long.parseLong((String)obj));
    }
  }
  }
}
