package com.xforceplus.ultraman.app.policymanagement.metadata.validator;

import com.xforceplus.ultraman.app.policymanagement.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.policymanagement.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-10-25
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(FlowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnapshotFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrgType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrgType.class.getSimpleName());
            }
        }
        if(clazz.equals(CreationMethod.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CreationMethod.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CreationMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrgStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrgStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReadStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReadStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReadStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CreateType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CreateType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CreateType.class.getSimpleName());
            }
        }
        if(clazz.equals(MessageType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MessageType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MessageType.class.getSimpleName());
            }
        }
        if(clazz.equals(EnableStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EnableStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EnableStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VariableType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != VariableType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, VariableType.class.getSimpleName());
            }
        }
        if(clazz.equals(WorkflowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != WorkflowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, WorkflowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PluginCode.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PluginCode.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PluginCode.class.getSimpleName());
            }
        }
        if(clazz.equals(DataType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DataType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DataType.class.getSimpleName());
            }
        }
        if(clazz.equals(DataSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DataSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DataSource.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MatchType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MatchType.class.getSimpleName());
            }
        }
        if(clazz.equals(HandleType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != HandleType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, HandleType.class.getSimpleName());
            }
        }
        if(clazz.equals(ResultType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ResultType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ResultType.class.getSimpleName());
            }
        }
        if(clazz.equals(FailedContinue.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FailedContinue.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FailedContinue.class.getSimpleName());
            }
        }
        if(clazz.equals(TbSalesOrderStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TbSalesOrderStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TbSalesOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddAfterSalesStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddAfterSalesStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddAfterSalesStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddConfirmStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddConfirmStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddConfirmStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddGroupRole.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddGroupRole.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddGroupRole.class.getSimpleName());
            }
        }
        if(clazz.equals(PddGroupStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddGroupStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddGroupStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddHomeDeliveryType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddHomeDeliveryType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddHomeDeliveryType.class.getSimpleName());
            }
        }
        if(clazz.equals(PddIsLuckyFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddIsLuckyFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddIsLuckyFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(PddKktBizType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddKktBizType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddKktBizType.class.getSimpleName());
            }
        }
        if(clazz.equals(PddOrderStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddOrderStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddPayType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddPayType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddPayType.class.getSimpleName());
            }
        }
        if(clazz.equals(PddOrderControlStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddOrderControlStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddOrderControlStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddShippingType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddShippingType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddShippingType.class.getSimpleName());
            }
        }
        if(clazz.equals(PddStockOutHandleStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddStockOutHandleStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddStockOutHandleStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddTradeType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddTradeType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddTradeType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyOrderTypes.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DyOrderTypes.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DyOrderTypes.class.getSimpleName());
            }
        }
        if(clazz.equals(DyOrderStatys.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DyOrderStatys.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DyOrderStatys.class.getSimpleName());
            }
        }
        if(clazz.equals(DyPayType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DyPayType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DyPayType.class.getSimpleName());
            }
        }
        if(clazz.equals(KsOrderStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != KsOrderStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, KsOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(KsCpsType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != KsCpsType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, KsCpsType.class.getSimpleName());
            }
        }
        if(clazz.equals(KsCoType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != KsCoType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, KsCoType.class.getSimpleName());
            }
        }
        if(clazz.equals(KsPayType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != KsPayType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, KsPayType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyTradeType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DyTradeType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DyTradeType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyGoodsType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DyGoodsType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DyGoodsType.class.getSimpleName());
            }
        }
        if(clazz.equals(OmsTradeStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OmsTradeStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OmsTradeStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceivableOrderType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReceivableOrderType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReceivableOrderType.class.getSimpleName());
            }
        }
        if(clazz.equals(EcChannel.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EcChannel.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EcChannel.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CheckStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CheckStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillChangeRecordSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillChangeRecordSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillChangeRecordSource.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceivableOrderStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReceivableOrderStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReceivableOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyPayType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != JkyPayType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, JkyPayType.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyTradeFrom.class)) {
            isValid = vals.stream()
                    .filter(val -> null != JkyTradeFrom.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, JkyTradeFrom.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyPayStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != JkyPayStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, JkyPayStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyTradeStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != JkyTradeStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, JkyTradeStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyInvoiceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != JkyInvoiceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, JkyInvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyIsBillCheck.class)) {
            isValid = vals.stream()
                    .filter(val -> null != JkyIsBillCheck.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, JkyIsBillCheck.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyLogisticType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != JkyLogisticType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, JkyLogisticType.class.getSimpleName());
            }
        }
        if(clazz.equals(DealStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DealStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DealStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(EbsBackStauts.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EbsBackStauts.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EbsBackStauts.class.getSimpleName());
            }
        }
        if(clazz.equals(PddRefundOperatorRole.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddRefundOperatorRole.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddRefundOperatorRole.class.getSimpleName());
            }
        }
        if(clazz.equals(PddUserShippingStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddUserShippingStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddUserShippingStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
